package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackProcessQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackProcessService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackConvert;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackProcessDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackProcessDO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 问题反馈服务
 *
 * @author Lemon
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemProblemFeedbackServiceImpl implements PrdSystemProblemFeedbackService {

    private final PrdSystemProblemFeedbackDAO dao;
    private final PrdSystemProblemFeedbackProcessService processService;
    private final PrdSystemProblemFeedbackProcessDAO processDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleDAO roleDAO;

    @Autowired
    private SysUserRpcService sysUserService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdMessageConfigService messageConfigService;

    @Override
    @Transactional
    public PrdSystemProblemFeedbackVO insert(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackDO ado = PrdSystemProblemFeedbackConvert.INSTANCE.toDo(payload);
        // 反馈状态修改为处理中，回复状态待管理员回复,且在反馈处理过程中新增一条（xxx提出了问题反馈）
        ado.setFeedbackStatus("handing");
        ado.setReplyStatus("2");
        ado.setReadAmount(0L);
        ado.setCommonFlag(0);
        ado.setUrgentFlag(0);
        // 默认负责人设置为运维管理员
        List<Long> operationAdmins = roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        if (operationAdmins != null && !operationAdmins.isEmpty()) {
            ado.setDirectorUserId(operationAdmins.get(0));
        }
        ado = dao.save(ado);
        // 获取系统当前用户
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
        processDO.setFeedbackId(ado.getId());
        String content = current.getLastName() + "提出了问题反馈";
        processDO.setContent(content);
        processDAO.save(processDO);
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        String userName = userDetails == null ? "" : userDetails.getUser().getUsername();
        // 给用户发消息通知
        if (operationAdmins != null && !operationAdmins.isEmpty()) {
            String noticeSource = org.apache.commons.lang3.StringUtils.join(operationAdmins, ",");
            PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001504");
            Map<String, Object> result = new HashMap<>();
            result.put("fromUser", userName);
            result.put("action", "回复了");
            result.put("url", String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s", ado.getId()));
            messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
//            messageConfigService.addJobMessage(ado.getId(),"reply",null,userName,noticeSource , "问题反馈新增通知",String.format("%s新增了一条中新增了一条问题反馈处理消息，请及时查看",userName),"进入查看",String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s",ado.getId()));
        }
        return PrdSystemProblemFeedbackConvert.INSTANCE.toVo(ado);
    }

    @Override
    @Transactional
    public PrdSystemProblemFeedbackVO update(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackDO ado = PrdSystemProblemFeedbackConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        return PrdSystemProblemFeedbackConvert.INSTANCE.toVo(ado);
    }

    @Override
    @Transactional
    public Long updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload) {
        return dao.updateByKeyDynamic(payload);
    }

    @Override
    public PagingVO<PrdSystemProblemFeedbackVO> paging(PrdSystemProblemFeedbackQuery query) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Long userId = user.getUser().getId();
        //运维管理员
        List<Long> messageToUserIds = roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        //如果运维管理员是当前登录人的话，
//        if(messageToUserIds!=null && !messageToUserIds.isEmpty() && messageToUserIds.get(0).equals(userId)){
//            query.setOpsAdmin(userId);
//        }
        List<OrderItem> orders = Lists.newArrayList();
        if ((!ObjectUtils.isEmpty(query.getPageFlag())) && query.getPageFlag().compareTo(1) == 0) {
            OrderItem orderItem1 = new OrderItem();
            orderItem1.setColumn("urgentFlag");
            orderItem1.setAsc(false);
            orders.add(orderItem1);
        }
        OrderItem orderItem2 = new OrderItem();
        orderItem2.setColumn("createTime");
        orderItem2.setAsc(false);
        query.setOrders(orders);
        orders.add(orderItem2);
        PagingVO<PrdSystemProblemFeedbackVO> pagingVO = dao.queryPaging(query);
        List<PrdSystemProblemFeedbackVO> feedbackVOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty(feedbackVOList)) {
            return pagingVO;
        }
        List<Long> feedbackIdList = feedbackVOList.stream().map(PrdSystemProblemFeedbackVO::getId).collect(Collectors.toList());
        PrdSystemProblemFeedbackProcessQuery processQuery = new PrdSystemProblemFeedbackProcessQuery();
        processQuery.setFeedbackIdList(feedbackIdList);
        List<PrdSystemProblemFeedbackProcessVO> processVOList = processDAO.queryListDynamic(processQuery);
        LocalDateTime now = LocalDateTime.now();
        for (PrdSystemProblemFeedbackVO feedbackVO : feedbackVOList) {
            PrdSystemProblemFeedbackProcessVO processVO = processVOList.stream().filter(e -> e.getFeedbackId().compareTo(feedbackVO.getId()) == 0).max((a1, a2) -> a1.getCreateTime().compareTo(a2.getCreateTime())).get();
            if (!ObjectUtils.isEmpty(processVO)) {
                feedbackVO.setLastProcessTime(processVO.getCreateTime());
                feedbackVO.setReplyTime(processVO.getCreateTime());
                long noReplyTimeInterval = ChronoUnit.HOURS.between(processVO.getCreateTime(), now);
                feedbackVO.setNoReplyTimeInterval(noReplyTimeInterval);
            }
        }
        // 翻译
        transaction(feedbackVOList);
        return pagingVO;
    }

    @Override
    @Transactional
    public PrdSystemProblemFeedbackVO queryByKey(Long key) {
        PrdSystemProblemFeedbackVO problemFeedbackVO = dao.queryByKey(key);
        if (ObjectUtils.isEmpty(problemFeedbackVO)) {
            return problemFeedbackVO;
        }
        // 查询问题反馈处理过程
        PrdSystemProblemFeedbackProcessQuery query = new PrdSystemProblemFeedbackProcessQuery();
        query.setFeedbackIdList(Collections.singletonList(problemFeedbackVO.getId()));
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("createTime");
        orderItem.setAsc(true);
        query.setOrders(Collections.singletonList(orderItem));
        List<PrdSystemProblemFeedbackProcessVO> processVOList = processService.queryList(query);
        problemFeedbackVO.setProcessList(processVOList);
        // 问题反馈的阅览量增加1
        PrdSystemProblemFeedbackPayload payload = new PrdSystemProblemFeedbackPayload();
        payload.setId(problemFeedbackVO.getId());
        payload.setReadAmount(problemFeedbackVO.getReadAmount() + 1);
        dao.updateByKeyDynamic(payload);
        // 翻译
        transaction(Collections.singletonList(problemFeedbackVO));
        return problemFeedbackVO;
    }

    @Override
    @Transactional
    public void closeProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List<Long> handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty(handleIds)) {
            throw TwException.error("", "请选择一个或多个操作数据");
        }
        // 获取系统当前用户
        //SysUserDTO current = sysUserService.current();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<>();
        List<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<>();
        // jpa的保存没有忽略空值的保存
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = dao.queryDyIdIn(handleIds);
        if (CollectionUtils.isEmpty(prdSystemProblemFeedbackDOS)) {
            throw TwException.error("", "操作数据不存在");
        }
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty(feedbackDO)) {
                throw TwException.error("", "操作数据不存在");
            }
            feedbackDO.setId(id);
            if (StringUtils.hasText(payload.getCloseReason())) {
                feedbackDO.setCloseReason(payload.getCloseReason());
            }
            feedbackDO.setFeedbackStatus("close");
            feedbackDO.setUrgentFlag(0);
            feedbackDOList.add(feedbackDO);

            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            String content = "";
            if (StringUtils.hasText(payload.getCloseReasonDesc())) {
                content = current.getLastName() + "关闭了问题反馈, 关闭理由为:" + payload.getCloseReasonDesc();
            } else {
                content = current.getLastName() + "关闭了问题反馈";
            }
            processDO.setContent(content);
            processDOList.add(processDO);
        }
        dao.saveAll(feedbackDOList);
        processDAO.saveAll(processDOList);
    }

    @Override
    public void openProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List<Long> handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty(handleIds)) {
            throw TwException.error("", "请选择一个或多个操作数据");
        }
        // 获取系统当前用户
        //SysUserDTO current = sysUserService.current();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<>();
        List<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<>();
        // jpa的保存没有忽略空值的保存
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty(feedbackDO)) {
                throw TwException.error("", "操作数据不存在");
            }
            feedbackDO.setId(id);
            feedbackDO.setFeedbackStatus("handing");
            feedbackDOList.add(feedbackDO);

            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            String content = current.getLastName() + "打开了问题反馈";
            processDO.setContent(content);
            processDOList.add(processDO);
        }
        dao.saveAll(feedbackDOList);
        processDAO.saveAll(processDOList);
    }

    @Override
    public void urgentProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List<Long> handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty(handleIds)) {
            throw TwException.error("", "请选择一个或多个操作数据");
        }
        // 获取系统当前用户
        //SysUserDTO current = sysUserService.current();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<>();
        List<PrdSystemProblemFeedbackProcessDO> processDOList = new ArrayList<>();
        // jpa的保存没有忽略空值的保存
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty(feedbackDO)) {
                throw TwException.error("", "操作数据不存在");
            }
            feedbackDO.setId(id);
            feedbackDO.setUrgentFlag(1);
            feedbackDOList.add(feedbackDO);

            PrdSystemProblemFeedbackProcessDO processDO = new PrdSystemProblemFeedbackProcessDO();
            processDO.setFeedbackId(id);
            String content = current.getLastName() + "请求加急处理问题反馈";
            processDO.setContent(content);
            processDOList.add(processDO);
        }
        dao.saveAll(feedbackDOList);
        processDAO.saveAll(processDOList);
    }

    @Override
    public void commonProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        List<Long> handleIds = payload.getHandleIds();
        if (CollectionUtils.isEmpty(handleIds)) {
            throw TwException.error("", "请选择一个或多个操作数据");
        }
        List<PrdSystemProblemFeedbackDO> feedbackDOList = new ArrayList<>();
        // jpa的保存没有忽略空值的保存
        List<PrdSystemProblemFeedbackDO> prdSystemProblemFeedbackDOS = dao.queryDyIdIn(handleIds);
        for (Long id : handleIds) {
            PrdSystemProblemFeedbackDO feedbackDO = prdSystemProblemFeedbackDOS.stream().filter(e -> id.compareTo(e.getId()) == 0).findFirst().get();
            if (ObjectUtils.isEmpty(feedbackDO)) {
                throw TwException.error("", "操作数据不存在");
            }
            feedbackDO.setId(id);
            feedbackDO.setCommonFlag(payload.getCommonFlag());
            feedbackDOList.add(feedbackDO);
        }
        dao.saveAll(feedbackDOList);
    }

    /**
     * 查询时间段内的问题数量和解决数量
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @Override
    public Map<String, List<Map<String, Object>>> statisticalNumber(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> numberStatisticalByAll = dao.findNumberStatisticalByAll(startDate, endDate);
        List<Map<String, Object>> numberStatisticalByClose = dao.findNumberStatisticalByClose(startDate, endDate);
        Map<String, List<Map<String, Object>>> resultMap = Maps.newHashMap();
        resultMap.put("all", numberStatisticalByAll);
        resultMap.put("close", numberStatisticalByClose);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> findNumberStatisticalGroupByProblemType(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> jpaResult = dao.findNumberStatisticalGroupByProblemType(startDate, endDate);
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (Map<String, Object> result : jpaResult) {
            Map<String, Object> resultMap = new HashMap<>(result);
            resultList.add(resultMap);
            if (ObjectUtils.isEmpty(result.get("problemType"))) {
                continue;
            }
            String problemType = cacheUtil.transferSystemSelection("sys:problem_feedback:problem_type", (String) result.get("problemType"));
            resultMap.put("problemType", problemType);
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> findNumberStatisticalGroupByFunctionId(LocalDateTime startDate, LocalDateTime endDate) {
        List<Map<String, Object>> jpaResult = dao.findNumberStatisticalGroupByFunctionId(startDate, endDate);
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (Map<String, Object> result : jpaResult) {
            Map<String, Object> resultMap = new HashMap<>(result);
            resultList.add(resultMap);
            if (ObjectUtils.isEmpty(result.get("functionId"))) {
                continue;
            }
            String functionName = cacheUtil.getFunctionById(Long.valueOf(String.valueOf(result.get("functionId")))).getFunctionName();
            resultMap.put("functionName", functionName);
        }
        return resultList;
    }

    @Override
    public Long findWorkProblemFeedbackByUserId(Long userId) {
        //运维管理员
        List<Long> messageToUserIds = roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        PrdSystemProblemFeedbackQuery query = new PrdSystemProblemFeedbackQuery();
        // todo 目前没有考虑管理员的问题反馈
        query.setReplyStatus("1");
        query.setFeedbackStatus("handing");
        query.setDirectorUserId(userId);
//        if(messageToUserIds!=null && !messageToUserIds.isEmpty() && messageToUserIds.get(0).equals(userId)){
//            query.setOpsAdmin(userId);
//        }
        return dao.queryPaging(query).getTotal();
    }

    // 翻译
    private void transaction(List<PrdSystemProblemFeedbackVO> list) {
        // 查询人员信息
        List<Long> userIdList = new ArrayList<>();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty(e.getDirectorUserId())) {
                userIdList.add(e.getDirectorUserId());
            }
            if (!ObjectUtils.isEmpty(e.getCreateUserId())) {
                userIdList.add(e.getCreateUserId());
            }
        });
        List<SysUserVO> sysUserVOS = sysUserService.getByIds(userIdList);
        Map<Long, SysUserVO> sysUserVOMap = sysUserVOS.stream().collect(Collectors.toMap(SysUserVO::getId, Function.identity()));
        for (PrdSystemProblemFeedbackVO vo : list) {
            // 反馈状态
            vo.setFeedbackStatusDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:feedback_status", vo.getFeedbackStatus()));
            // 回复状态
            vo.setReplyStatusDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:reply_status", vo.getReplyStatus()));
            // 问题类型
            vo.setProblemTypeDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:problem_type", vo.getProblemType()));
            // todo 关于人的翻译，目前没有什么公共查询的方法,暂时只能用这个了，看之后用什么替换
            if (!ObjectUtils.isEmpty(vo.getDirectorUserId())) {
                SysUserVO sysUser = sysUserVOMap.get(vo.getDirectorUserId());
                if (!ObjectUtils.isEmpty(sysUser)) {
                    vo.setDirectorUserIdDesc(sysUser.getFirstName());
                }
            }
            // 严重程度翻译
            vo.setLevelDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:feedback_level", vo.getLevel()));
            // 所属功能
            if (!ObjectUtils.isEmpty(vo.getFunctionId())) {
                PrdSystemFunctionVO systemFunctionVO = cacheUtil.getFunctionById(vo.getFunctionId());
                if (!ObjectUtils.isEmpty(systemFunctionVO)) {
                    String functionName = systemFunctionVO.getFunctionName();
                    vo.setFunctionIdDesc(functionName);
                }
            }
            // 翻译创建人
            SysUserVO createUser = sysUserVOMap.get(vo.getCreateUserId());
            if (!ObjectUtils.isEmpty(createUser)) {
                vo.setCreateUserName(createUser.getFirstName());
            }
            // 关闭理由翻译
            vo.setCloseReasonDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:close_reason", vo.getCloseReason()));
        }
    }
}
