package com.elitesland.tw.tw5.server.prd.work.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author Lemon
 */
@Entity
@Table(name = "prd_work_assignment")
@org.hibernate.annotations.Table(appliesTo = "prd_work_assignment", comment = "指派")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdWorkAssignmentDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 4092913429186163955L;

    @Comment("指派编号")
    @Column()
    private String assignmentNo;

    @Comment("名称")
    @Column()
    private String assignmentName;

    @Comment("优先级")
    @Column()
    private String priority;

    @Comment("指派人")
    @Column()
    private Long assignUserId;

    @Comment("协助人")
    @Column()
    private String assistUserIds;

    @Comment("类型")
    @Column()
    private String assignmentType;

    @Comment("开始日期")
    @Column()
    private LocalDate startDate;

    @Comment("完成日期")
    @Column()
    private LocalDate finishDate;

    @Comment("状态")
    @Column()
    private String assignmentStatus;

    @Comment("实际开始日期")
    @Column()
    private LocalDate actualStartDate;

    @Comment("实际完成日期")
    @Column()
    private LocalDate actualFinishDate;

    @Comment("任务id")
    @Column()
    private Long taskId;

    @Comment("完成人")
    @Column()
    private Long finishUserId;

    @Comment("进度")
    @Column()
    private Integer progress;

    @Comment("任务描述")
    @Column()
    private String assignmentDesc;

    @Comment("附件")
    @Column()
    private String fileCodes;

    @Comment("父id")
    @Column()
    private Long parentId;
}
