/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.office.storage;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStorageMutator;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStoragePathBuilder;
import com.elitesland.tw.tw5.server.prd.office.util.file.FileUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
@Primary
public class LocalFileStorage
implements FileStorageMutator,
FileStoragePathBuilder {
    private String storageAddress;
    @Value(value="${office.files.storage.folder:documents}")
    private String storageFolder;
    @Value(value="${office.files.docservice.url.example:}")
    private String docserviceUrlExample;
    @Value(value="${office.files.docservice.history.postfix:-hist}")
    private String historyPostfix;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private HttpServletRequest request;

    @Override
    public void configure(String address) {
        this.storageAddress = address;
        if (this.storageAddress == null) {
            try {
                this.storageAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.storageAddress = "unknown_storage";
            }
        }
        this.storageAddress.replaceAll("[^0-9a-zA-Z.=]", "_");
        this.createDirectory(Paths.get(this.getStorageLocation(), new String[0]));
    }

    @Override
    public String getStorageLocation() {
        String serverPath = System.getProperty("user.dir");
        String directory = Paths.get(this.storageAddress, new String[0]).isAbsolute() ? this.storageAddress + File.separator : serverPath + File.separator + this.storageFolder + File.separator + this.storageAddress + File.separator;
        if (!Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            this.createDirectory(Paths.get(directory, new String[0]));
        }
        return directory;
    }

    @Override
    public String getFileLocation(String fileName) {
        if (fileName.contains(File.separator)) {
            return this.getStorageLocation() + fileName;
        }
        return this.getStorageLocation() + this.fileUtility.getFileName(fileName);
    }

    @Override
    public void createDirectory(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean createFile(Path path, InputStream stream) {
        if (Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            File file = Files.createFile(path, new FileAttribute[0]).toFile();
            try (FileOutputStream out = new FileOutputStream(file);){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean deleteFile(String fileName) {
        if ((fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8)).isBlank()) {
            return false;
        }
        String filenameWithoutExt = this.fileUtility.getFileNameWithoutExtension(fileName);
        Path filePath = fileName.contains(File.separator) ? Paths.get(fileName, new String[0]) : Paths.get(this.getFileLocation(fileName), new String[0]);
        Path filePathWithoutExt = fileName.contains(File.separator) ? Paths.get(filenameWithoutExt, new String[0]) : Paths.get(this.getStorageLocation() + filenameWithoutExt, new String[0]);
        boolean fileDeleted = FileSystemUtils.deleteRecursively((File)filePath.toFile());
        boolean fileWithoutExtDeleted = FileSystemUtils.deleteRecursively((File)filePathWithoutExt.toFile());
        return fileDeleted && fileWithoutExtDeleted;
    }

    @Override
    public boolean deleteFileHistory(String fileName) {
        if ((fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8)).isBlank()) {
            return false;
        }
        Path fileHistoryPath = Paths.get(this.getStorageLocation() + this.getHistoryDir(fileName), new String[0]);
        Path fileHistoryPathWithoutExt = Paths.get(this.getStorageLocation() + this.getHistoryDir(this.fileUtility.getFileNameWithoutExtension(fileName)), new String[0]);
        boolean historyDeleted = FileSystemUtils.deleteRecursively((File)fileHistoryPath.toFile());
        boolean historyWithoutExtDeleted = FileSystemUtils.deleteRecursively((File)fileHistoryPathWithoutExt.toFile());
        return historyDeleted || historyWithoutExtDeleted;
    }

    @Override
    public String updateFile(String fileName, byte[] bytes) {
        Path path = this.fileUtility.generateFilepath(this.getStorageLocation(), fileName);
        try {
            Files.write(path, bytes, new OpenOption[0]);
            return path.getFileName().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean moveFile(Path source, Path destination) {
        try {
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean copyFile(Path source, Path destination) {
        try {
            Files.copy(source, destination, (CopyOption[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean writeToFile(String pathName, String payload) {
        boolean bl;
        FileWriter fw = new FileWriter(pathName);
        try {
            fw.write(payload);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fw.close();
        return bl;
    }

    @Override
    public String getForcesavePath(String fileName, Boolean create) {
        Object directory = this.getStorageLocation();
        Path path = Paths.get((String)directory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return "";
        }
        directory = this.getFileLocation(fileName) + this.historyPostfix + File.separator;
        path = Paths.get((String)directory, new String[0]);
        if (!create.booleanValue() && !Files.exists(path, new LinkOption[0])) {
            return "";
        }
        this.createDirectory(path);
        directory = (String)directory + fileName;
        path = Paths.get((String)directory, new String[0]);
        if (!create.booleanValue() && !Files.exists(path, new LinkOption[0])) {
            return "";
        }
        return directory;
    }

    @Override
    public Resource loadFileAsResource(String fileName) {
        String fileLocation = this.getForcesavePath(fileName, false);
        if (fileLocation.isBlank()) {
            fileLocation = this.getFileLocation(fileName);
        }
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Resource loadFileAsResourceHistory(String fileName, String version, String file) {
        String fileLocation = this.getStorageLocation() + fileName + "-hist" + File.separator + version + File.separator + file;
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public File[] getStoredFiles() {
        File file = new File(this.getStorageLocation());
        return file.listFiles(pathname -> pathname.isFile());
    }

    @Override
    public void createMeta(String fileName, String uid, String uname) {
        String histDir = this.getHistoryDir(this.getFileLocation(fileName));
        Path path = Paths.get(histDir, new String[0]);
        this.createDirectory(path);
        JSONObject json = new JSONObject();
        json.put("created", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        json.put("id", (Object)uid);
        json.put("name", (Object)uname);
        File meta = new File(histDir + File.separator + "createdInfo.json");
        try (FileWriter writer = new FileWriter(meta);){
            json.writeJSONString((Appendable)writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean createOrUpdateFile(Path path, InputStream stream) {
        if (!Files.exists(path, new LinkOption[0])) {
            return this.createFile(path, stream);
        }
        try {
            Files.write(path, stream.readAllBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getServerUrl(Boolean forDocumentServer) {
        if (forDocumentServer.booleanValue() && !this.docserviceUrlExample.equals("")) {
            return this.docserviceUrlExample;
        }
        return this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
    }

    @Override
    public String getHistoryDir(String path) {
        return path + this.historyPostfix;
    }

    @Override
    public int getFileVersion(String historyPath, Boolean ifIndexPage) {
        int n;
        block11: {
            Path path;
            if (ifIndexPage.booleanValue()) {
                path = Paths.get(this.getStorageLocation() + this.getHistoryDir(historyPath), new String[0]);
            } else {
                path = Paths.get(historyPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    return 1;
                }
            }
            Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);
            try {
                n = stream.filter(file -> Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet()).size();
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
            stream.close();
        }
        return n;
    }

    public String getStorageAddress() {
        return this.storageAddress;
    }
}

