/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.AddressBookEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgPersonConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgCompanyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.org.service.AsyncEmployeeServiceImpl;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrdOrgEmployeeServiceImpl
implements PrdOrgEmployeeService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeServiceImpl.class);
    private final PrdOrgEmployeeDAO dao;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgCompanyDAO daoComppany;
    private final PrdSystemSelectionService service;
    private final AsyncEmployeeServiceImpl serviceAsync;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final ExcelUtil excelUtil;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.shortcut.size}")
    private Integer shortcutSize = 5;
    @Autowired
    private UserRpcService userRpcService;
    @Value(value="${tw5.user_default.password}")
    private String default_password = "111111";
    @Value(value="${tw5.user_default.role_id}")
    private Long default_role_id;
    @Value(value="${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Transactional
    public PrdOrgEmployeeVO saveTenantUser(PrdOrgTenantEmployeePayload payload) {
        Long tenantId = Long.valueOf(payload.getTenantId());
        String shortcutIds = this.getDefultShortcut();
        String aa = "" + (System.currentTimeMillis() + (long)((int)(Math.random() * 10.0)));
        String substring = aa.substring(aa.length() - 7);
        PrdOrgPersonDO pDO = new PrdOrgPersonDO();
        pDO.setUserName(payload.getAdminAccount());
        pDO.setPersonName(payload.getAdminAccount());
        pDO.setEnabled(true);
        pDO.setTenantId(tenantId);
        this.dao.savePerson(pDO);
        PrdOrgEmployeeDO ado = new PrdOrgEmployeeDO();
        ado.setEmployeeNo(substring);
        ado.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
        ado.setEmployeeName(payload.getAdminAccount());
        ado.setPersonId(pDO.getId());
        ado.setUserId(payload.getAdminUserId());
        ado.setShortcutIds(shortcutIds);
        ado.setTenantId(tenantId);
        ado.setCompanyId(1001L);
        ado.setCompanyName(this.daoComppany.queryNameByKey(ado.getCompanyId()));
        ado = this.dao.save(ado);
        ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
        roleDO.setRoleId(this.default_role_id);
        roleDO.setUserId(ado.getUserId());
        userRoleDOS.add(roleDO);
        this.dao.saveUserRoleAll(userRoleDOS);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdOrgEmployeeVO insert(PrdOrgEmployeePayload payload) {
        String shortcutIds = this.getDefultShortcut();
        PrdOrgEmployeeDO ado = this.insertEmployee(payload, shortcutIds);
        this.checkEmployeeRef(payload.getOrgId(), payload.getParentId(), ado.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(ado.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        this.dao.saveRef(refDo);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdOrgEmployeeVO insertByTenant(PrdOrgEmployeePayload payload) {
        if (this.dao.queryByCode(payload.getEmployeeNo()) == null) {
            if (StringUtils.hasText((String)payload.getMobile())) {
                payload.setLastName(payload.getEmployeeName());
                String wecom = this.qyWxCommunicationService.getQyWxuserid(payload.getMobile());
                UserCreateDTO param = new UserCreateDTO();
                param.setUsername(payload.getUserName());
                param.setPassword(this.default_password);
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                param.setSourceType("sys");
                ApiResult obj = this.userRpcService.upsert(param);
                if (obj == null || obj.getCode() != 200) {
                    throw TwException.error("" + obj.getCode(), obj.getMsg());
                }
                PrdOrgPersonDO pDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
                pDO = this.dao.savePerson(pDO);
                if (null != payload.getInitTenantId()) {
                    pDO.setTenantId(payload.getInitTenantId());
                }
                PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
                ado.setWecomId(wecom);
                ado.setPersonId(pDO.getId());
                ado.setUserId(Long.valueOf("" + obj.getData()));
                if (null != payload.getInitTenantId()) {
                    ado.setTenantId(payload.getInitTenantId());
                }
                if (ado.getCompanyId() != null) {
                    ado.setCompanyName(this.daoComppany.queryNameByKey(ado.getCompanyId()));
                }
                ado = this.dao.save(ado);
                ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
                    for (Long roleId : payload.getRoleIds()) {
                        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                        roleDO.setRoleId(roleId);
                        roleDO.setUserId(ado.getUserId());
                        if (null != payload.getInitTenantId()) {
                            roleDO.setTenantId(payload.getInitTenantId());
                        }
                        userRoleDOS.add(roleDO);
                    }
                } else {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(this.default_role_id);
                    roleDO.setUserId(ado.getUserId());
                    if (null != payload.getInitTenantId()) {
                        roleDO.setTenantId(payload.getInitTenantId());
                    }
                    userRoleDOS.add(roleDO);
                }
                this.dao.saveUserRoleAll(userRoleDOS);
                PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
                refDo.setJoinDate(LocalDate.now());
                refDo.setOrgId(payload.getOrgId());
                refDo.setUserId(ado.getUserId());
                refDo.setParentId(payload.getParentId());
                refDo.setIsDefault(0);
                if (null != payload.getInitTenantId()) {
                    refDo.setTenantId(payload.getInitTenantId());
                }
                this.dao.saveRef(refDo);
                return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
            }
            throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateForApp(PrdOrgEmployeePayload payload) {
        PrdOrgEmployeeVO eDo = this.dao.queryByKey(payload.getId());
        this.dao.update(payload);
        payload.setPersonId(eDo.getPersonId());
        this.dao.updatePerson(payload);
        return 0L;
    }

    @Transactional
    public Long update(PrdOrgEmployeePayload payload) {
        PrdOrgEmployeeVO eDo = this.dao.queryByKey(payload.getId());
        String subType = payload.getSubType();
        if (subType.equals("system") || subType.equals("person")) {
            if (subType.equals("system")) {
                UserCreateDTO param = new UserCreateDTO();
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                param.setId(eDo.getUserId());
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setUsername(payload.getUserName());
                this.userRpcService.upsert(param);
                if (!eDo.getEmployeeName().equals(payload.getEmployeeName())) {
                    this.dao.update(payload);
                }
                if (payload.getRoleIds() != null) {
                    if (payload.getRoleIds().size() == 0) {
                        this.dao.deleteRolesByUserId(eDo.getUserId());
                    } else {
                        ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                        for (Long roleId : payload.getRoleIds()) {
                            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                            roleDO.setRoleId(roleId);
                            roleDO.setUserId(eDo.getUserId());
                            userRoleDOS.add(roleDO);
                        }
                        this.dao.deleteRolesByUserId(eDo.getUserId());
                        this.dao.saveUserRoleAll(userRoleDOS);
                    }
                }
            }
            payload.setPersonId(eDo.getPersonId());
            this.dao.updatePerson(payload);
        }
        if (subType.equals("company")) {
            PrdOrgEmployeeDO employeeDO = this.dao.queryByCode(payload.getEmployeeNo());
            if (employeeDO != null && employeeDO.getId().longValue() != payload.getId().longValue()) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
            if (payload.getCompanyId() != null) {
                payload.setCompanyName(this.daoComppany.queryNameByKey(payload.getCompanyId()));
            }
            this.dao.update(payload);
        }
        return 0L;
    }

    @Transactional
    public Long updateEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {
        ArrayList<PrdOrgEmployeeRefDO> refDOS = new ArrayList<PrdOrgEmployeeRefDO>();
        int defaultNum = 0;
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            Long userId = (Long)map.get(payload.getOrgId());
            if (userId != null) {
                throw TwException.error("", "\u5458\u5de5\u7ec4\u7ec7\u4fe1\u606f\u91cd\u590d");
            }
            map.put(payload.getOrgId(), payload.getUserId());
            Long parentId = payload.getParentId();
            if (!ObjectUtils.isEmpty((Object)parentId) && parentId != 0L && parentId.longValue() == payload.getUserId().longValue()) {
                throw TwException.error("", "\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b58\u5728\u4e0d\u5408\u7406\u64cd\u4f5c");
            }
            if (payload.getIsDefault() == 0) {
                ++defaultNum;
            }
            PrdOrgEmployeeRefDO ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
            if (payload.getId() == null || payload.getId() == 0L) {
                ado.setJoinDate(LocalDate.now());
            }
            refDOS.add(ado);
        }
        if (defaultNum != 1) {
            throw TwException.error("", "\u5458\u5de5\u9ed8\u8ba4\u7ec4\u7ec7\u63d0\u4ea4\u5f02\u5e38");
        }
        this.dao.saveAllRef(refDOS);
        return 0L;
    }

    public List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query) {
        return this.dao.queryList(query);
    }

    public PrdOrgEmployeeVO queryByKey(Long key) {
        PrdOrgEmployeeVO vo = this.dao.queryByKey(key);
        vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        vo.setRoleDatas(this.dao.queryUserRoles(vo.getUserId()));
        vo.setDataRefVOS(this.dao.queryOrgListByKey(vo.getUserId()));
        vo.setIdValidDatas(this.fileUtil.getFileDatas(vo.getIdValidCodes()));
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
        vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
        return vo;
    }

    public Set<Long> queryParentIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> parentIds = new HashSet<Long>();
        this.getParentIds(userId, prdOrgEmployeeRefVOS, parentIds);
        return parentIds;
    }

    public Set<Long> queryOneSubordinatesIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> subordinatesIds = new HashSet<Long>();
        this.getOneSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        return subordinatesIds;
    }

    public Set<Long> querySubordinatesIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> subordinatesIds = new HashSet<Long>();
        this.getSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        return subordinatesIds;
    }

    void getSubordinatesIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> subordinatesIds) {
        Set<Long> collect = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getParentId() != null && refVO.getParentId().equals(userId)).map(PrdOrgEmployeeRefVO::getUserId).collect(Collectors.toSet());
        if (!ObjectUtils.isEmpty(collect)) {
            subordinatesIds.addAll(collect);
            collect.forEach(childId -> this.getSubordinatesIds((Long)childId, prdOrgEmployeeRefVOS, subordinatesIds));
        }
    }

    public Set<Long> queryOneParentIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> parentIds = new HashSet<Long>();
        this.getOneParentIds(userId, prdOrgEmployeeRefVOS, parentIds);
        return parentIds;
    }

    void getParentIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> parentIds) {
        PrdOrgEmployeeRefVO refVO2;
        Optional<PrdOrgEmployeeRefVO> first = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getUserId().equals(userId)).findFirst();
        if (first.isPresent() && (refVO2 = first.get()).getParentId() != null && !refVO2.getParentId().equals(0) && !refVO2.getParentId().equals(refVO2.getUserId())) {
            parentIds.add(refVO2.getParentId());
            this.getParentIds(refVO2.getParentId(), prdOrgEmployeeRefVOS, parentIds);
        }
    }

    void getOneParentIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> parentIds) {
        PrdOrgEmployeeRefVO refVO2;
        Optional<PrdOrgEmployeeRefVO> first = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getUserId().equals(userId)).findFirst();
        if (first.isPresent() && (refVO2 = first.get()).getParentId() != null && !refVO2.getParentId().equals(0) && !refVO2.getParentId().equals(refVO2.getUserId())) {
            parentIds.add(refVO2.getParentId());
        }
    }

    void getOneSubordinatesIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> subordinatesIds) {
        Set collect = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getParentId() != null && refVO.getParentId().equals(userId)).map(PrdOrgEmployeeRefVO::getUserId).collect(Collectors.toSet());
        subordinatesIds.addAll(collect);
    }

    public PagingVO<PrdOrgEmployeeVO> paging(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> evo = this.dao.queryPaging(query);
        List vos = evo.getRecords();
        for (PrdOrgEmployeeVO vo : vos) {
            vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
            vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
            vo.setIdTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeIdType.getCode(), vo.getIdType()));
            vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        }
        return evo;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        ArrayList<Long> personIds = new ArrayList<Long>();
        List<PrdOrgEmployeeVO> employeeVOS = this.dao.queryEmployeeList(keys);
        for (PrdOrgEmployeeVO eDo : employeeVOS) {
            userIds.add(eDo.getUserId());
            personIds.add(eDo.getPersonId());
        }
        this.dao.deleteRefSoft(userIds);
        this.dao.deleteSoft(keys);
        this.dao.deletePersonSoft(personIds);
        for (PrdOrgEmployeeVO eDo : employeeVOS) {
            this.userRpcService.delete(eDo.getUserId());
        }
        return true;
    }

    public boolean resetEmployeePawword(Long userId) {
        this.userRpcService.updatePwd(userId, this.default_password);
        return true;
    }

    public void downloadPlus(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/employeeBatch.xlsx");
        List list = new ArrayList();
        if (StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("data")) {
            PagingVO<PrdOrgEmployeeVO> evo = this.paging(query);
            list = evo.getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5458\u5de5\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 8, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 11, 1, "\u516c\u53f8\u6570\u636e", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 13, 1, "\u7ec4\u7ec7\u6570\u636e", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 17, 1, "\u5c97\u4f4d\u6570\u636e", 2, "A");
            if (batchProjectSheet != null) {
                if (list.size() > 0) {
                    int nextRow = 1;
                    for (PrdOrgEmployeeVO dataPayload : list) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, dataPayload.getUserName());
                        this.excelUtil.setCellValue((Row)row, 2, dataPayload.getPersonName());
                        this.excelUtil.setCellValue((Row)row, 3, dataPayload.getSexName());
                        this.excelUtil.setCellFormulas((Row)row, 4, "VLOOKUP(D:rowNo,LOV!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 5, dataPayload.getEmail());
                        this.excelUtil.setCellValue((Row)row, 6, dataPayload.getMobile());
                        this.excelUtil.setCellValue((Row)row, 7, dataPayload.getEmployeeNo());
                        this.excelUtil.setCellValue((Row)row, 8, dataPayload.getIdTypeName());
                        this.excelUtil.setCellFormulas((Row)row, 9, "VLOOKUP(I:rowNo,LOV!C:D,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 10, dataPayload.getIdNo());
                        this.excelUtil.setCellValue((Row)row, 11, dataPayload.getCompanyName());
                        this.excelUtil.setCellFormulas((Row)row, 12, "VLOOKUP(L:rowNo,\u516c\u53f8\u6570\u636e!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 13, dataPayload.getOrgName());
                        this.excelUtil.setCellFormulas((Row)row, 14, "VLOOKUP(N:rowNo,\u7ec4\u7ec7\u6570\u636e!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 15, dataPayload.getParentName());
                        this.excelUtil.setCellValue((Row)row, 16, dataPayload.getParentNo());
                        this.excelUtil.setCellValue((Row)row, 17, dataPayload.getJobsName());
                        this.excelUtil.setCellFormulas((Row)row, 18, "VLOOKUP(R:rowNo,\u5c97\u4f4d\u6570\u636e!A:B,2,FALSE)");
                        ++nextRow;
                    }
                } else {
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 4, "VLOOKUP(D:rowNo,LOV!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 9, "VLOOKUP(I:rowNo,LOV!C:D,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(L:rowNo,\u516c\u53f8\u6570\u636e!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(N:rowNo,\u7ec4\u7ec7\u6570\u636e!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 18, "VLOOKUP(R:rowNo,\u5c97\u4f4d\u6570\u636e!A:B,2,FALSE)");
                }
            }
            List<PrdOrgOrganizationRefVO> orgList = this.daoOrg.queryAll(null, null, null);
            Sheet orgSheet = workbook.getSheet("\u7ec4\u7ec7\u6570\u636e");
            if (!CollectionUtils.isEmpty(orgList) && orgSheet != null) {
                int nextRow = 1;
                for (PrdOrgOrganizationRefVO org : orgList) {
                    Long addrNo = org.getOrgId();
                    String addrName = org.getOrgName();
                    if (addrNo == null || !StringUtils.hasText((String)addrName)) continue;
                    Row row = orgSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, addrName);
                    this.excelUtil.setCellValue(row, 1, addrNo);
                    ++nextRow;
                }
            }
            List jobList = this.service.selectByCondition(FunctionSelectionEnum.EmployeeJobs.getCode());
            Sheet jobSheet = workbook.getSheet("\u5c97\u4f4d\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)jobList) && jobSheet != null) {
                int nextRow = 1;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (!StringUtils.hasText((String)selectionName) || !StringUtils.hasText((String)selectionValue)) continue;
                    Row row = jobSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, selectionName);
                    this.excelUtil.setCellValue(row, 1, selectionValue);
                    ++nextRow;
                }
            }
            List<PrdOrgCompanyVO> companyList = this.daoComppany.queryList(AddressBookEnum.RelateIntercompany.getCode());
            Sheet companySheet = workbook.getSheet("\u516c\u53f8\u6570\u636e");
            if (!CollectionUtils.isEmpty(companyList) && companySheet != null) {
                int nextRow = 1;
                for (PrdOrgCompanyVO company : companyList) {
                    Long selectionValue = company.getId();
                    String selectionName = company.getCompanyName();
                    if (!StringUtils.hasText((String)selectionName) || selectionValue == null) continue;
                    Row row = companySheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, selectionName);
                    this.excelUtil.setCellValue(row, 1, "" + selectionValue);
                    ++nextRow;
                }
            }
            String fileName = "\u5458\u5de5\u6279\u91cf\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public boolean importEmployees(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u5458\u5de5\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<PrdOrgEmployeePayload> employeePayloads = new ArrayList<PrdOrgEmployeePayload>();
        ArrayList<String> employeeCodes = new ArrayList<String>();
        ArrayList<String> emails = new ArrayList<String>();
        ArrayList<Object> mobiles = new ArrayList<Object>();
        ArrayList<String> parentNos = new ArrayList<String>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String parentNo;
            String orgId;
            Row row = sheet.getRow(i);
            PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
            String email = ExcelUtil.getCellFormatValue(row.getCell(5));
            if (StringUtils.hasText((String)email)) {
                if (emails.contains(email)) {
                    throw TwException.error("", "\u90ae\u7bb1\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u90ae\u7bb1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            emails.add(email);
            employeePayload.setUserName(email);
            employeePayload.setEmail(email);
            String mobile = ExcelUtil.getCellFormatValue(row.getCell(6));
            if (StringUtils.hasText((String)mobile)) {
                if (mobiles.contains(mobile)) {
                    throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u4e3a\u7a7a");
            }
            mobiles.add(mobile);
            employeePayload.setMobile(mobile);
            employeePayload.setEmployeeName(ExcelUtil.getCellFormatValue(row.getCell(2)));
            employeePayload.setPersonName(employeePayload.getEmployeeName());
            employeePayload.setSex(ExcelUtil.getCellFormatValue(row.getCell(4)));
            String code = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (StringUtils.hasText((String)code)) {
                if (employeeCodes.contains(code)) {
                    throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u5458\u5de5\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            }
            employeeCodes.add(code);
            employeePayload.setEmployeeNo(code);
            employeePayload.setIdType(ExcelUtil.getCellFormatValue(row.getCell(9)));
            employeePayload.setIdNo(ExcelUtil.getCellFormatValue(row.getCell(10)));
            String companyId = ExcelUtil.getCellFormatValue(row.getCell(12));
            if (StringUtil.isInteger(companyId)) {
                employeePayload.setCompanyId(Long.valueOf(companyId));
            }
            if (StringUtil.isInteger(orgId = ExcelUtil.getCellFormatValue(row.getCell(14)))) {
                employeePayload.setOrgId(Long.valueOf(orgId));
            }
            if (StringUtils.hasText((String)(parentNo = ExcelUtil.getCellFormatValue(row.getCell(16))))) {
                parentNos.add(parentNo);
                employeePayload.setParentNo(parentNo);
            }
            employeePayload.setJobs(ExcelUtil.getCellFormatValue(row.getCell(18)));
            employeePayloads.add(employeePayload);
        }
        HashMap<String, Long> parentMap = new HashMap<String, Long>();
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        String shortcutIds = this.getDefultShortcut();
        ArrayList<PrdOrgEmployeeRefDO> refDOs = new ArrayList<PrdOrgEmployeeRefDO>();
        for (PrdOrgEmployeePayload employeePayload : employeePayloads) {
            PrdOrgEmployeeDO edo = this.insertEmployee(employeePayload, shortcutIds);
            if (parentNos.contains(edo.getEmployeeNo())) {
                parentMap.put(edo.getEmployeeNo(), edo.getUserId());
                parentNos.remove(edo.getEmployeeNo());
            }
            PrdOrgEmployeeRefDO refDo2 = new PrdOrgEmployeeRefDO();
            refDo2.setJoinDate(LocalDate.now());
            refDo2.setOrgId(employeePayload.getOrgId());
            refDo2.setUserId(edo.getUserId());
            refDo2.setIsDefault(0);
            refDOs.add(refDo2);
            employeeMap.put(edo.getUserId(), employeePayload.getParentNo());
        }
        List<PrdOrgEmployeeDO> employeeList = this.dao.queryListByCode(parentNos);
        employeeList.forEach(employeeDO -> parentMap.put(employeeDO.getEmployeeNo(), employeeDO.getUserId()));
        refDOs.forEach(refDo -> refDo.setParentId((Long)parentMap.get(employeeMap.get(refDo.getUserId()))));
        this.dao.saveAllRef(refDOs);
        return true;
    }

    @Transactional
    public boolean deleteOrgRefSoft(Long userId, List<Long> orgIds) {
        long num = this.dao.deleteEmployeeRefSoft(userId, orgIds);
        if (num > (long)orgIds.size()) {
            throw TwException.error("", "\u5458\u5de5\u9ed8\u8ba4\u7ec4\u7ec7\u4e0d\u53ef\u88ab\u79fb\u9664");
        }
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean updateWecomId(List<Long> userIds) {
        List<PrdOrgEmployeeVO> employeeVOS = this.dao.queryMobileList(userIds);
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            this.serviceAsync.queryWecomId(employeeVO);
        }
        return true;
    }

    public Map<Long, Long> getV4AndV5UserIds() {
        HashMap<Long, Long> userMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5UserIds = this.dao.getV4AndV5UserIds();
        for (Map<String, Object> v4AndV5UserId : v4AndV5UserIds) {
            Long userId = (Long)v4AndV5UserId.get("userId");
            Long userIdV4 = (Long)v4AndV5UserId.get("userIdV4");
            if (userId == null || userIdV4 == null) continue;
            userMap.put(userIdV4, userId);
        }
        return userMap;
    }

    public PrdOrgEmployeeRefVO queryEmployeeRef(Long userId) {
        return this.dao.queryEmployeeRef(userId);
    }

    public Set<Long> queryParentIdByIds(List<Long> userIds) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryParentIdByIds(userIds);
        HashSet<Long> parentIds = new HashSet<Long>();
        if (prdOrgEmployeeRefVOS == null) {
            return null;
        }
        for (PrdOrgEmployeeRefVO prdOrgEmployeeRefVO : prdOrgEmployeeRefVOS) {
            parentIds.add(prdOrgEmployeeRefVO.getParentId());
        }
        return parentIds;
    }

    private PrdOrgEmployeeDO insertEmployee(PrdOrgEmployeePayload payload, String shortcutIds) {
        if (this.dao.queryByCode(payload.getEmployeeNo()) == null) {
            if (StringUtils.hasText((String)payload.getMobile())) {
                payload.setLastName(payload.getEmployeeName());
                String wecom = this.qyWxCommunicationService.getQyWxuserid(payload.getMobile());
                UserCreateDTO param = new UserCreateDTO();
                param.setUsername(payload.getUserName());
                param.setPassword(this.default_password);
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                param.setSourceType("sys");
                ApiResult obj = this.userRpcService.upsert(param);
                if (obj == null || obj.getCode() != 200) {
                    throw TwException.error("" + obj.getCode(), obj.getMsg());
                }
                PrdOrgPersonDO pDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
                pDO = this.dao.savePerson(pDO);
                PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
                ado.setWecomId(wecom);
                ado.setPersonId(pDO.getId());
                ado.setUserId(Long.valueOf("" + obj.getData()));
                ado.setShortcutIds(shortcutIds);
                if (ado.getCompanyId() != null) {
                    ado.setCompanyName(this.daoComppany.queryNameByKey(ado.getCompanyId()));
                }
                ado = this.dao.save(ado);
                ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
                    for (Long roleId : payload.getRoleIds()) {
                        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                        roleDO.setRoleId(roleId);
                        roleDO.setUserId(ado.getUserId());
                        userRoleDOS.add(roleDO);
                    }
                } else {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(this.default_role_id);
                    roleDO.setUserId(ado.getUserId());
                    userRoleDOS.add(roleDO);
                }
                this.dao.saveUserRoleAll(userRoleDOS);
                return ado;
            }
            throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    void checkEmployeeRef(Long orgId, Long parentId, Long userId) {
        PrdOrgEmployeeRefDO employeeRefDO;
        if (!ObjectUtils.isEmpty((Object)parentId) && parentId != 0L && (employeeRefDO = this.dao.queryByOrgIdAndUserId(orgId, parentId)) != null && employeeRefDO.getParentId() != 0L && employeeRefDO.getParentId().longValue() == userId.longValue()) {
            throw TwException.error("", "\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b58\u5728\u4e0d\u5408\u7406\u64cd\u4f5c");
        }
    }

    String getDefultShortcut() {
        List<Long> shortcutIds = this.dao.getShortcuts(this.shortcutSize);
        return org.apache.commons.lang3.StringUtils.join((Object[])shortcutIds.toArray(), (String)",");
    }

    public List<Long> querySubUserIdByParentId(Long parentId) {
        return this.dao.querySubUserIdByParentId(parentId);
    }

    public PrdOrgEmployeeServiceImpl(PrdOrgEmployeeDAO dao, PrdOrgOrganizationDAO daoOrg, PrdOrgCompanyDAO daoComppany, PrdSystemSelectionService service, AsyncEmployeeServiceImpl serviceAsync, QyWxCommunicationService qyWxCommunicationService, ExcelUtil excelUtil, FileUtil fileUtil, CacheUtil cacheUtil) {
        this.dao = dao;
        this.daoOrg = daoOrg;
        this.daoComppany = daoComppany;
        this.service = service;
        this.serviceAsync = serviceAsync;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.excelUtil = excelUtil;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
    }
}

