/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdScheduleDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdScheduleRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdScheduleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdScheduleRepo repo;
    private final QPrdScheduleDO qdo = QPrdScheduleDO.prdScheduleDO;
    private final QPrdScheduleRepeatDO rqdo = QPrdScheduleRepeatDO.prdScheduleRepeatDO;
    private final QPrdCalendarDO rcdo = QPrdCalendarDO.prdCalendarDO;
    private final QPrdOrgEmployeeDO employeeDO = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgPersonDO personDO = QPrdOrgPersonDO.prdOrgPersonDO;

    public PrdScheduleDO save(PrdScheduleDO ado) {
        return (PrdScheduleDO)this.repo.save(ado);
    }

    public List<PrdScheduleDO> saveAll(List<PrdScheduleDO> dos) {
        return this.repo.saveAll(dos);
    }

    public PrdScheduleVO queryByKey(Long id) {
        JPAQuery<PrdScheduleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (PrdScheduleVO)jpaQuery.fetchFirst();
    }

    public PrdScheduleVO queryByQyWxScheduleId(String id) {
        JPAQuery<PrdScheduleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.qyWxScheduleId.eq((Object)id));
        return (PrdScheduleVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PrdScheduleVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdScheduleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.title, this.qdo.description, this.qdo.location, this.qdo.startTime, this.qdo.endTime, this.qdo.calId, this.qdo.allowActiveJoin, this.qdo.isRepeat, this.qdo.isRemind, this.qdo.allDay, this.qdo.remindBeforeEventSecs, this.qdo.createUserId, this.qdo.qyWxScheduleId, this.rqdo.repeatType, this.rqdo.repeatUntil, this.rqdo.isCustomRepeat, this.rqdo.repeatInterval, this.rqdo.repeatDayOfWeek, this.rqdo.repeatDayOfMonth, this.rqdo.exdate, this.employeeDO.employeeName, this.rcdo.title.as("calTitle"), this.rcdo.color})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.rqdo)).on((Predicate)this.qdo.id.longValue().eq(this.rqdo.secheduleId))).leftJoin((EntityPath)this.rcdo)).on((Predicate)this.rcdo.id.longValue().eq(this.qdo.calId))).leftJoin((EntityPath)this.employeeDO)).on((Predicate)this.qdo.createUserId.eq(this.employeeDO.userId));
        return jpaQuery;
    }

    private JPAQuery<PrdScheduleVO> getJpaQueryWhere(PrdScheduleQuery query) {
        JPAQuery<PrdScheduleVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getTitle())) {
            jpaQuery.where((Predicate)this.qdo.title.like(SqlUtil.toSqlLikeString(query.getTitle())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDescription())) {
            jpaQuery.where((Predicate)this.qdo.description.like(SqlUtil.toSqlLikeString(query.getDescription())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCalId())) {
            jpaQuery.where((Predicate)this.qdo.calId.eq((Object)query.getCalId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartTime()) && !ObjectUtils.isEmpty((Object)query.getEndTime())) {
            jpaQuery.where((Predicate)this.qdo.startTime.goe((Comparable)query.getStartTime()));
            jpaQuery.where((Predicate)this.qdo.endTime.loe((Comparable)query.getEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCalIds())) {
            List<String> list = Arrays.asList(query.getCalIds().split(","));
            List collect = list.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
            jpaQuery.where((Predicate)this.qdo.calId.in(collect));
        } else {
            jpaQuery.where((Predicate)this.qdo.calId.in(Collections.singletonList(-1L)));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdScheduleVO> queryListDynamic(PrdScheduleQuery query) {
        JPAQuery<PrdScheduleVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdScheduleVO> queryPaging(PrdScheduleQuery query) {
        JPAQuery<PrdScheduleVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public long updateByKeyDynamic(PrdSchedulePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTitle() != null) {
            update.set((Path)this.qdo.title, (Object)payload.getTitle());
        }
        if (payload.getDescription() != null) {
            update.set((Path)this.qdo.description, (Object)payload.getDescription());
        }
        if (payload.getStartTime() != null) {
            update.set(this.qdo.startTime, (Object)payload.getStartTime());
        }
        if (payload.getEndTime() != null) {
            update.set(this.qdo.endTime, (Object)payload.getEndTime());
        }
        if (payload.getAllowActiveJoin() != null) {
            update.set(this.qdo.allowActiveJoin, (Object)payload.getAllowActiveJoin());
        }
        if (payload.getIsRepeat() != null) {
            update.set(this.qdo.isRepeat, (Object)payload.getIsRepeat());
        }
        if (payload.getIsRemind() != null) {
            update.set(this.qdo.isRemind, (Object)payload.getIsRemind());
        }
        if (payload.getRemindBeforeEventSecs() != null) {
            update.set(this.qdo.remindBeforeEventSecs, (Object)payload.getRemindBeforeEventSecs());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("endTime")) {
            update.setNull(this.qdo.endTime);
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public PrdScheduleDAO(JPAQueryFactory jpaQueryFactory, PrdScheduleRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

