package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
@Entity
@Table(name = "prd_business_table", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_table", comment = "业务对象表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessTableDO extends BaseModel implements Serializable  {
    /** 名称 */
    @Comment("名称")
    @Column()
    private String name;
    /** 数据库表名 */
    @Comment("数据库表名")
    @Column()
    private String tableName;
    /** 业务关系 MIAN 主表 DETAIL 明细表 */
    @Comment("业务关系 MIAN 主表 DETAIL 明细表")
    @Column()
    private String type;
    /** 功能主键 prd_system_function.id */
    @Comment("功能主键 prd_system_function.id")
    @Column()
    private Long functionId;
    /** 是否启用 */
    @Comment("是否启用")
    @Column()
    private Boolean enabled;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessTableDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
