package com.elitesland.tw.tw5.server.prd.schedule.service;
import com.elitesland.tw.tw5.api.prd.schedule.payload.*;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleAttendeesVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleRepeatVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleAttendeesConvert;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleAttendeesDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleAttendeesDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdScheduleRepeatConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleRepeatDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:日程service
 * @date 2022/4/19 - 21:41
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdScheduleServiceImpl implements PrdScheduleService {

    private final PrdScheduleDAO dao;
    private final PrdScheduleRepeatDAO repeatDAO;
    private final PrdScheduleAttendeesDAO attendeesDAO;
    private final QyWxCommunicationService wxService;
    private final PrdCalendarService calendarService;
    private final PrdCalendarDAO calendarDAO;

    @Transactional
    @Override
    public PrdScheduleVO insertOrUpdate(PrdSchedulePayload payload) {
        if(!payload.getEndTime().isAfter(payload.getStartTime())){
            throw TwException.error("","日程的结束时间必须大于日程的开始时间！");
        }
        boolean isNew = payload.getId()==null?true:false;
        PrdScheduleDO ado = PrdScheduleConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        Long scheduleId = ado.getId();
        payload.setId(ado.getId());
        payload.setCreateUserId(ado.getCreateUserId());
        List<PrdScheduleAttendeesPayload> attendees = payload.getAttendees();
        //获取成员列表
        List<PrdScheduleAttendeesVO> attendeesVOs = attendeesDAO.queryByScheduleId(scheduleId);
        if(attendees!=null && !attendees.isEmpty() && !payload.getSkipAttendees()){
            for (PrdScheduleAttendeesPayload attendee : attendees) {
                boolean b = attendeesVOs.stream().anyMatch(m -> m.getUserId().equals(attendee.getUserId()));
                if (!b){
                    attendee.setSecheduleId(scheduleId);
                    PrdScheduleAttendeesDO prdScheduleAttendeesDO = PrdScheduleAttendeesConvert.INSTANCE.toDo(attendee);
                    attendeesDAO.save(prdScheduleAttendeesDO);
                }
            }
            for(PrdScheduleAttendeesVO attendeesVO:attendeesVOs){
                boolean b = attendees.stream().anyMatch(m -> m.getUserId().equals(attendeesVO.getUserId()));
                List<Long> ids= new ArrayList<>();
                if(!b){
                    ids.add(attendeesVO.getId());
                }
                //删除该条目
                attendeesDAO.deleteSoft(ids);
            }
        }else{
            //删除全部
            List<Long> collect = attendeesVOs.stream().map(item -> item.getId()).collect(Collectors.toList());
            attendeesDAO.deleteSoft(collect);
        }

        PrdScheduleRepeatPayload repeat = payload.getRepeat();
        if(repeat!=null && payload.getIsRepeat()==1 && !payload.getSkipRepeat()){
            repeat.setSecheduleId(scheduleId);
            PrdScheduleRepeatDO prdScheduleRepeatDO = PrdScheduleRepeatConvert.INSTANCE.toDo(repeat);
            if(repeat.getRepeatDayOfMonth()!=null || repeat.getRepeatDayOfMonth()!=""){
                List<Integer> elements = transCapitalToNumber(repeat.getRepeatDayOfMonth());
                String join = StringUtils.join(elements, ",");
                repeat.setRepeatDayOfMonth(join);
            }
            repeatDAO.save(prdScheduleRepeatDO);
        }
        //如果是从企业微信端过来的请求，不用调同步
        if(payload.getFromQyWx()==null || !payload.getFromQyWx()){
            if(isNew){
                //同步数据到微信
                String qywxScheduleId = wxService.saveSchedule(transferToQyWxPayload(payload));
                //更新本地日程企业微信id
                ado.setQyWxScheduleId(qywxScheduleId);
                dao.save(ado);
            }else{
                PrdScheduleVO prdScheduleVO = dao.queryByKey(payload.getId());
                payload.setCreateUserId(prdScheduleVO.getCreateUserId());
                payload.setQyWxScheduleId(prdScheduleVO.getQyWxScheduleId());
                //同步数据到微信
                wxService.updateSchedule(transferToQyWxPayload(payload));
            }
        }
        return PrdScheduleConvert.INSTANCE.toVo(ado);
    }


    /*
     * @Author Zoey
     * @Description 将日程payload转为微信payload
     * @Date 17:40 2022/4/23
     **/
    @Override
    public QyWxSchedulePayload transferToQyWxPayload(PrdSchedulePayload schedulePayload){
        QyWxSchedulePayload payload = new QyWxSchedulePayload();
        Long calId = schedulePayload.getCalId();
        payload.setCal_id(calendarDAO.queryByKey(calId).getQyWxCalId());
        payload.setSchedule_id(schedulePayload.getQyWxScheduleId());
        payload.setSummary(schedulePayload.getTitle());
        payload.setDescription(schedulePayload.getDescription());
        payload.setLocation(schedulePayload.getLocation());
        payload.setStart_time(schedulePayload.getStartTime().atZone(ZoneOffset.ofHours(8)).toEpochSecond());
        payload.setEnd_time(schedulePayload.getEndTime().atZone(ZoneOffset.ofHours(8)).toEpochSecond());
        payload.setSkip_attendees(schedulePayload.getSkipAttendees());
        Long createUserId = schedulePayload.getCreateUserId();
        String weComId=calendarService.getWeComId(createUserId);
        payload.setOrganizer(weComId);
        List<QyWxScheduleAttendeesPayload> qyWxScheduleAttendees = new ArrayList<>();
        List<PrdScheduleAttendeesPayload> attendees = schedulePayload.getAttendees();
        if(attendees!=null && !attendees.isEmpty()){
            for (PrdScheduleAttendeesPayload attendee : attendees) {
                QyWxScheduleAttendeesPayload qywxAttendee = new QyWxScheduleAttendeesPayload();
                Long userId = attendee.getUserId();
                qywxAttendee.setUserid(calendarService.getWeComId(userId));
                qyWxScheduleAttendees.add(qywxAttendee);
            }
        }
        PrdScheduleRepeatPayload repeat = schedulePayload.getRepeat();
        if(repeat!=null){
            QyWxScheduleRepeatPayload qyWxScheduleRepeat= new QyWxScheduleRepeatPayload();
            qyWxScheduleRepeat.setIs_remind(schedulePayload.getIsRemind());
            qyWxScheduleRepeat.setRemind_before_event_secs(schedulePayload.getRemindBeforeEventSecs());
            qyWxScheduleRepeat.setIs_repeat(schedulePayload.getIsRepeat());
            qyWxScheduleRepeat.setIs_custom_repeat(repeat.getIsCustomRepeat());
            qyWxScheduleRepeat.setRepeat_type(repeat.getRepeatType());
            qyWxScheduleRepeat.setRepeat_until(repeat.getRepeatUntil()==null?null:repeat.getRepeatUntil().atStartOfDay(ZoneOffset.ofHours(8)).toEpochSecond());
            qyWxScheduleRepeat.setRepeat_interval(repeat.getRepeatInterval());
            qyWxScheduleRepeat.setRepeat_day_of_week((repeat.getRepeatDayOfWeek()==null||repeat.getRepeatDayOfWeek()=="")?null:Arrays.stream(repeat.getRepeatDayOfWeek().split(",")).map(item->Integer.parseInt(item)+1).collect(Collectors.toList()));
            qyWxScheduleRepeat.setRepeat_day_of_month(transCapitalToNumber(repeat.getRepeatDayOfMonth()));
            if(repeat.getExdate()!=null){
                String[] split = repeat.getExdate().split(",");
                List<Map<String, Long>> excludeList = Arrays.stream(split).map(item -> {
                    Map<String, Long> timeMap = new HashMap<>();
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    long time = LocalDateTime.parse(item, dateTimeFormatter).atZone(ZoneOffset.ofHours(8)).toEpochSecond();
                    timeMap.put("start_time", time);
                    return timeMap;
                }).collect(Collectors.toList());
                qyWxScheduleRepeat.setExclude_time_list(excludeList);
            }
            qyWxScheduleRepeat.setTimezone(8);
            payload.setReminders(qyWxScheduleRepeat);
        }
        payload.setAttendees(qyWxScheduleAttendees);
        return payload;
    }



    /*
     * @Author Zoey
     * @Description 将微信payload转为日程payload
     * @Date 17:40 2022/4/23
     **/
    @Override
    public PrdSchedulePayload transferToPrdPayload(QyWxSchedulePayload schedulePayload){
        PrdSchedulePayload payload = new PrdSchedulePayload();
        //查询对应的日历id
        PrdCalendarVO prdCalendarVO = calendarDAO.queryByQyWxCalId(schedulePayload.getCal_id());
        payload.setCalId(prdCalendarVO.getId());
        payload.setQyWxScheduleId(schedulePayload.getSchedule_id());
        payload.setTitle(schedulePayload.getSummary());
        payload.setDescription(schedulePayload.getDescription());
        payload.setLocation(schedulePayload.getLocation());
        payload.setStartTime(Instant.ofEpochSecond(schedulePayload.getStart_time()).atZone(ZoneOffset.ofHours(8)).toLocalDateTime());
        payload.setEndTime(Instant.ofEpochSecond(schedulePayload.getEnd_time()).atZone(ZoneOffset.ofHours(8)).toLocalDateTime());
        payload.setSkipAttendees(schedulePayload.getSkip_attendees());
        String organizer = schedulePayload.getOrganizer();
        Long createUserId=calendarService.getUserIdByWeComId(organizer);
        payload.setCreateUserId(createUserId);
        List<PrdScheduleAttendeesPayload> prdScheduleAttendees = new ArrayList<>();
        List<QyWxScheduleAttendeesPayload> attendees = schedulePayload.getAttendees();
        if (attendees!=null && !attendees.isEmpty()){
            for (QyWxScheduleAttendeesPayload attendee : attendees) {
                PrdScheduleAttendeesPayload prdAttendee = new PrdScheduleAttendeesPayload();
                Long userId=calendarService.getUserIdByWeComId(attendee.getUserid());
                prdAttendee.setUserId(userId);
                prdAttendee.setUserId(1L);
                prdScheduleAttendees.add(prdAttendee);
            }
        }
        PrdScheduleRepeatPayload prdScheduleRepeat= new PrdScheduleRepeatPayload();
        QyWxScheduleRepeatPayload reminders = schedulePayload.getReminders();
        payload.setIsRemind(reminders.getIs_remind());
        payload.setIsRepeat(reminders.getIs_repeat());
        payload.setRemindBeforeEventSecs(reminders.getRemind_before_event_secs());
        prdScheduleRepeat.setIsCustomRepeat(reminders.getIs_custom_repeat());
        prdScheduleRepeat.setRepeatType(reminders.getRepeat_type());
        //时间戳转localDate
        LocalDate untilDate= LocalDate.now();
        if(reminders.getRepeat_until()!=null||reminders.getRepeat_until()==0){
            //大概10年不需要精确
            long time = schedulePayload.getStart_time() + (3600 * 24 * 365 * 10);
            untilDate = Instant.ofEpochSecond(time).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        }else{
            untilDate = Instant.ofEpochSecond(reminders.getRepeat_until()).atZone(ZoneOffset.ofHours(8)).toLocalDate();

        }
        prdScheduleRepeat.setRepeatUntil(untilDate);
        prdScheduleRepeat.setRepeatInterval(reminders.getRepeat_interval());
        prdScheduleRepeat.setRepeatDayOfWeek(reminders.getRepeat_day_of_week()==null?null:StringUtils.join(reminders.getRepeat_day_of_week().stream().map(item->item-1),","));
        prdScheduleRepeat.setRepeatDayOfMonth(transNumberToCapital(reminders.getRepeat_day_of_month()));
        if(reminders.getExclude_time_list()!=null && !reminders.getExclude_time_list().isEmpty()){
            String exdate = reminders.getExclude_time_list().stream().map(item -> {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long time = Long.valueOf(item.get("start_time")) * 1000L;
                String format = sdf.format(new Date(time));
                return format;
            }).collect(Collectors.joining(","));
            prdScheduleRepeat.setExdate(exdate);
        }
        payload.setAttendees(prdScheduleAttendees);
        payload.setRepeat(prdScheduleRepeat);
        return payload;
    }

    //前端组件问题导致需要做转化 A=10  B=11
    private String transNumberToCapital(List<Integer> numbers){
        if(numbers==null){
            return null;
        }
        numbers.stream().map(item->{
            int numberInt = item;
            if (numberInt>9){
                char capitalChar = (char)(numberInt + 55);
                return Character.toString(capitalChar);
            }
            return item;
        });
        return StringUtils.join(numbers,",");
    }
    private List<Integer> transCapitalToNumber(String capitals){
        if(capitals==null || capitals.length()<1){
            return null;
        }
        List<Integer> result= new ArrayList<>();
        String[] capital = capitals.split(",");
        for (String item : capital) {
            char capitalChar = item.charAt(0);
            if (capitalChar < 58) {
                result.add(Integer.parseInt(item));
            } else {
                //将字母转为数字
                result.add(Integer.parseInt(String.valueOf(capitalChar - 55)));
            }
        }
//        return result.toArray(new Integer[result.size()]);
        return result;
    }





    @Override
    public List<PrdScheduleVO> queryList(PrdScheduleQuery query) {
        List<PrdScheduleVO> scheduleVOS = dao.queryListDynamic(query);
        for (PrdScheduleVO scheduleVO : scheduleVOS) {
            if(scheduleVO.getRepeatDayOfMonth()!=null || scheduleVO.getRepeatDayOfMonth()!=""){
                //查询日程成员
                List<PrdScheduleAttendeesVO> attendeesVOs = attendeesDAO.queryByScheduleId(scheduleVO.getId());
                scheduleVO.setAttendeesVOS(attendeesVOs);

                List<Integer> elements = transCapitalToNumber(scheduleVO.getRepeatDayOfMonth());
                String join = StringUtils.join(elements, ",");
                scheduleVO.setRepeatDayOfMonthNumber(join);
            }
        }
        return scheduleVOS;
    }

    @Override
    public PrdScheduleVO queryDetail(Long id) {
        //查询日程
        PrdScheduleVO prdScheduleVO = dao.queryByKey(id);
        if(prdScheduleVO!=null){
            //查询日程成员
            List<PrdScheduleAttendeesVO> attendeesVOs = attendeesDAO.queryByScheduleId(prdScheduleVO.getId());
            //查询重复信息
            PrdScheduleRepeatVO repeatVo = repeatDAO.queryByScheduleId(prdScheduleVO.getId());
            prdScheduleVO.setRepeatVO(repeatVo);
            prdScheduleVO.setAttendeesVOS(attendeesVOs);

            // 新增repeatDayOfMonthNumber字段
            List<Integer> elements = transCapitalToNumber(prdScheduleVO.getRepeatDayOfMonth());
            String join = StringUtils.join(elements, ",");
            prdScheduleVO.setRepeatDayOfMonthNumber(join);
        }
        return prdScheduleVO;
    }

    @Transactional
    @Override
    public void deleteCurrent(Long id,String date) {
        LocalDateTime startTime = dao.queryByKey(id).getStartTime();
        int hour = startTime.getHour();
        int minute = startTime.getMinute();
        int second = startTime.getSecond();
        String exTime=date+
                " "+StringUtils.leftPad(String.valueOf(hour),2,"0")+
                ":"+StringUtils.leftPad(String.valueOf(minute),2,"0")+
                ":"+StringUtils.leftPad(String.valueOf(second),2,"0");
        PrdScheduleRepeatPayload payload = new PrdScheduleRepeatPayload();
        //获取日程重复
        PrdScheduleRepeatVO repeatVO = repeatDAO.queryByScheduleId(id);
        String exdate = repeatVO.getExdate();
        payload.setExdate((exdate==null || exdate=="")?exTime:exdate+","+exTime);
        payload.setId(repeatVO.getId());
        //更新repeat新增
        repeatDAO.updateByKeyDynamic(payload);
        //同步更新到企业微信
        PrdScheduleVO prdScheduleVO = queryDetail(id);
        PrdSchedulePayload prdSchedulePayload = transVoToPayLoad(prdScheduleVO);
        if(prdScheduleVO.getQyWxScheduleId()!=null){
            QyWxSchedulePayload qyWxSchedulePayload = transferToQyWxPayload(prdSchedulePayload);
            wxService.updateSchedule(qyWxSchedulePayload);
        }
    }

    @Transactional
    @Override
    public void deleteAfter(Long id,String date) {
        LocalDate repeatUntil = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        //获取今天的日期
        PrdScheduleRepeatPayload payload = new PrdScheduleRepeatPayload();
        //获取日程重复
        PrdScheduleRepeatVO repeatVO = repeatDAO.queryByScheduleId(id);
        payload.setId(repeatVO.getId());
        payload.setRepeatUntil(repeatUntil);
        //更新repeat新增
        repeatDAO.updateByKeyDynamic(payload);
        //同步更新到企业微信
        PrdScheduleVO prdScheduleVO = queryDetail(id);
        PrdSchedulePayload prdSchedulePayload = transVoToPayLoad(prdScheduleVO);
        if(prdScheduleVO.getQyWxScheduleId()!=null){
            QyWxSchedulePayload qyWxSchedulePayload = transferToQyWxPayload(prdSchedulePayload);
            wxService.updateSchedule(qyWxSchedulePayload);
        }
    }



    private PrdSchedulePayload transVoToPayLoad(PrdScheduleVO prdScheduleVO){
        PrdScheduleRepeatVO repeatVO = prdScheduleVO.getRepeatVO();
        List<PrdScheduleAttendeesVO> attendeesVOS = prdScheduleVO.getAttendeesVOS();
        PrdSchedulePayload prdSchedulePayload = PrdScheduleConvert.INSTANCE.toPayload(prdScheduleVO);
        //repeat要单独转否则转不过来
        if(repeatVO!=null){
            PrdScheduleRepeatPayload repeatPayload = PrdScheduleRepeatConvert.INSTANCE.toPayload(repeatVO);
            prdSchedulePayload.setRepeat(repeatPayload);
        }
        if(attendeesVOS!=null && !attendeesVOS.isEmpty()){
            List<PrdScheduleAttendeesPayload> attendeesPayloads= new ArrayList<>();
            for (PrdScheduleAttendeesVO attendeesVO : attendeesVOS) {
                PrdScheduleAttendeesPayload attendeesPayload = PrdScheduleAttendeesConvert.INSTANCE.toPayload(attendeesVO);
                attendeesPayloads.add(attendeesPayload);
            }
            prdSchedulePayload.setAttendees(attendeesPayloads);
        }
        return prdSchedulePayload;
    }



    @Transactional
    @Override
    public void updateCurrent(PrdSchedulePayload payload) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String date = dateTimeFormatter.format(payload.getStartTime());
        //删除当天
        deleteCurrent(payload.getId(),date);
        payload.setRepeat(new PrdScheduleRepeatPayload());
        payload.setIsRepeat(0);
        payload.setId(null);
        //保存日程
        insertOrUpdate(payload);
    }

    @Transactional
    @Override
    public void updateAfter(PrdSchedulePayload payload) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String date = dateTimeFormatter.format(payload.getStartTime());
        //删除今天及以后
        deleteAfter(payload.getId(),date);
        //保存日程
        payload.setId(null);
        payload.setQyWxScheduleId(null);
        PrdScheduleRepeatPayload repeat = payload.getRepeat();
        repeat.setId(null);
        insertOrUpdate(payload);
    }


    @Transactional
    @Override
    public void deleteSoft(List<Long> asList) {
        //同步删除企业微信日历
        for (Long scheduleId : asList) {
            PrdScheduleVO prdScheduleVO = dao.queryByKey(scheduleId);
            String qyWxScheduleId = prdScheduleVO.getQyWxScheduleId();
            if(qyWxScheduleId != null){
                wxService.deleteSchedule(qyWxScheduleId);
            }
        }
        dao.deleteSoft(asList);
    }




}
