package com.elitesland.tw.tw5.server.yeedoc.controller;

import com.elitesland.tw.tw5.api.yeedoc.service.YeedocWorkflowService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.workflow.payload.StartProcessPayload;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 易稻壳工作流交互
 *
 * @author carl
 * @date 2023-07-07
 */

@Api(tags = "项目")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/yeedoc")
@Slf4j
public class YeedocWorkflowController {
    private final YeedocWorkflowService yeedocWorkflowService;

    /**
     * 发起流程
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/submitProcess")
    @ApiOperation("发起流程")
    public TwOutputUtil submitProcess(@RequestBody StartProcessPayload payload) {
        return TwOutputUtil.ok(yeedocWorkflowService.submitProcess(payload));
    }
}
