package com.elitesland.tw.tw5.server.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.Map;

/**
 * @author zoey
 * @Description: 基于springboot restTemplate 的网络请求工具类
 * @date 2022/4/21 - 20:43
 */
@Component
@RequiredArgsConstructor
public class HttpUtil<k, v> {

    @Value("${tw4.isSync}")
    private Boolean tw4_isSync = false;

    @Value("${tw4.url}")
    private String tw4_url;

    private final RestTemplate restTemplate;

    /**
     * 生成post请求的JSON请求参数
     * 请求示例:
     * {
     * "id":1,
     * "name":"zoey"
     * }
     *
     * @return
     */
    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap) {

        //如果需要其它的请求头信息、都可以在这里追加
        HttpHeaders httpHeaders = new HttpHeaders();

        MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");

        httpHeaders.setContentType(type);

        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(jsonMap, httpHeaders);

        return httpEntity;
    }


    /**
     * 生成get参数请求url
     * 示例：https://0.0.0.0:80/api?u=u&o=o
     * 示例：https://0.0.0.0:80/api
     *
     * @param uri    请求的uri 示例: 0.0.0.0:80
     * @param params 请求参数
     * @return
     */
    public String generateRequestParameters(String uri, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder(uri);
        if (ObjectUtil.isNotEmpty(params)) {
            sb.append("?");
            for (Map.Entry map : params.entrySet()) {
                sb.append(map.getKey())
                        .append("=")
                        .append(map.getValue())
                        .append("&");
            }
            uri = sb.substring(0, sb.length() - 1);
            return uri;
        }
        return sb.toString();
    }


    /*
     * @Author Zoey
     * @Description get请求  结果示例：http://127.0.0.1:80/?name=zoey&sex=男
     * @Date 20:53 2022/4/21
     * @Param [java.util.Map<java.lang.String,java.lang.String>, java.lang.String, java.lang.String]
     * @return java.lang.String
     **/
    public String sendGet(String uri, Map<String, Object> uriMap) {

        ResponseEntity responseEntity = restTemplate.getForEntity
                (
                        generateRequestParameters(uri, uriMap),
                        String.class
                );
        return (String) responseEntity.getBody();
    }

    /*
     * @Author Zoey
     * @Description post请求、请求参数为json
     * @Date 20:56 2022/4/21
     * @Param [java.lang.String, java.util.Map<java.lang.String,java.lang.String>]
     * @return java.lang.String
     **/
    public String sendPost(String uri, Map<String, Object> jsonMap) {
        ResponseEntity<String> apiResponse = restTemplate.postForEntity
                (
                        uri,
                        generatePostJson(jsonMap),
                        String.class
                );
        return apiResponse.getBody();
    }

    /*
     * @Author carl.wang
     * @Description 数据同步请求
     * @Date 20:56 2022/7/1
     * @Param [java.lang.String, java.util.Map<java.lang.String,java.lang.String>]
     * @return java.lang.String
     **/
    public String sendSyncPost(String uri, Map<String, Object> jsonMap) {
        if (tw4_isSync) {
            final String result = cn.hutool.http.HttpUtil.post(tw4_url + uri, jsonMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    /*
     * @Author carl.wang
     * @Description 数据同步请求
     * @Date 20:56 2022/7/1
     * @Param [java.lang.String, java.util.Map<java.lang.String,java.lang.String>]
     * @return java.lang.String
     **/
    public String sendSyncGet(String uri, Map<String, Object> uriMap) {
        if (tw4_isSync) {
            final String result = cn.hutool.http.HttpUtil.get(tw4_url + uri, uriMap);
            return result;
        }
        return "{\"ok\":true}";
    }

    //获取返回结果里的Stirng类型的参数
    public String geResultData(String result) {
        //if (result == null || "".equals(result)) {
        //    throw TwException.error("433", "同步数据失败");
        //}
        //try {
        //    Map parse = (Map) JSON.parse(result);
        //    if ((parse.get("ok") + "").equals("true")) {
        //        if (parse.get("datum") != null) {
        //            return parse.get("datum") + "";
        //        }
        //        return null;
        //    } else {
        //        String errmsg = parse.get("reason") + "";
        //        throw TwException.error(parse.get("errcode") + "", "同步数据失败,详情：" + errmsg);
        //    }
        //} catch (Exception ex) {
        //    throw TwException.error("434", "同步数据失败,详情：" + result);
        //}
        return "";
    }
    //获取返回结果里的Stirng类型的参数
    public Object getYeedocResultData(String result) {
        if (result == null || "".equals(result)) {
            throw TwException.error("433", "动态指定任务负责人-请求数据失败");
        }
        try {
            Map parse = (Map) JSON.parse(result);
            if ((parse.get("IsSuccess") + "").equals("true")) {
                if (parse.get("Data") != null) {
                    return  parse.get("Data");
                }
                return null;
            } else {
                String errmsg = parse.get("Message") + "";
                throw TwException.error(parse.get("Code") + "", "动态指定任务负责人-请求数据失败,详情：" + errmsg);
            }
        } catch (Exception ex) {
            throw TwException.error("434", "动态指定任务负责人-请求数据失败,详情：" + result);
        }
    }
    //获取返回结果里的Stirng类型的参数
    public String geStrItem(String result, String itemName, String errorMsg) {
        Map parse = (Map) JSON.parse(result);
        if (parse.get("errcode").equals(0)) {
            if (parse.get(itemName) != null) {
                return (String) parse.get(itemName);
            }
            return null;
        } else {
            String errmsg = (String) parse.get("errmsg");
            errmsg = errmsg.split(",")[0];
            throw TwException.error(parse.get("errcode").toString(), errorMsg + ",详情：" + errmsg);
        }
    }

    /*
     * @Author carl

     **/
    public Map sendGetCallMap(String uri, Map<String, Object> uriMap) {

        ResponseEntity responseEntity = restTemplate.getForEntity
                (
                        generateRequestParameters(uri, uriMap),
                        Map.class
                );
        return (Map) responseEntity.getBody();
    }

}

