package com.elitesland.tw.tw5.server.common;

import org.springframework.expression.*;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wangding
 * @version 1.0
 */
public class SpelUtil {
    public static String parseStringExpression(String expression, Object context) {
        ExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(context);
        evaluationContext.addPropertyAccessor(new PropertyAccessor() {
            @Override
            public Class<?>[] getSpecificTargetClasses() {
                return new Class[]{HashMap.class};
            }

            @Override
            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return target instanceof Map;
            }

            @Override
            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                Map map = (Map) target;
                return new TypedValue(map.get(name));
            }

            @Override
            public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
                return false;
            }

            @Override
            public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {

            }
        });
        Expression ex = parser.parseExpression(expression, new TemplateParserContext());
        return ex.getValue(evaluationContext, String.class);
    }


    public static Object parseExpressionToObject(String expression, Object context) {
        ExpressionParser parser = new SpelExpressionParser();
        EvaluationContext ctx = new StandardEvaluationContext(context);
        Expression ex = parser.parseExpression(expression);
        return ex.getValue(ctx);
    }

    /**
     * #{age1},#{age4.![age1]}
     *
     * @param expression 表达式
     * @param context    上下文
     * @return 集合
     */
//    @SuppressWarnings("unchecked")
    public static List<Long> parseLongListExpression(String expression, Object context) {
        ExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(context);
        evaluationContext.addPropertyAccessor(new PropertyAccessor() {
            @Override
            public Class<?>[] getSpecificTargetClasses() {
                return new Class[]{HashMap.class};
            }

            @Override
            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return target instanceof Map;
            }

            @Override
            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                Map map = (Map) target;
                return new TypedValue(map.get(name));
            }

            @Override
            public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
                return false;
            }

            @Override
            public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {

            }
        });
        Expression ex = parser.parseExpression(expression, new TemplateParserContext());
        List list = ex.getValue(evaluationContext, List.class);
        List<Long> longList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            list.forEach(e -> {
                Long longValue;
                if (e instanceof Long) {
                    longValue = (Long) e;
                } else {
                    longValue = Long.valueOf(e.toString());
                }
                longList.add(longValue);
            });
        }
        return longList;
    }

}
