package com.elitesland.tw.tw5.server.common.change.entity;


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 通用变更信息表(com_change)实体类
 *
 * @author carl
 */

@Entity
@Table(name = "com_change")
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "com_change", comment = "通用变更信息表")
@Where(clause = "delete_flag= 0")
public class ComChangeDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Column()
    @Comment("变更类型")
    private String changeType;

    @Column()
    @Comment("变更信息")
    private String changeContent;

    @Column()
    @Comment("变更单据id")
    private String changeDocId;

    @Column()
    @Comment("版本号")
    private Integer versionNo;

    @Column()
    @Comment("变更状态")
    private String changeStatus;

    /**
     * 流程状态
     */
    @Comment("流程状态")
    @Column()
    private String apprStatus;

    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String apprProcInstId;
    
    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
}

