package com.elitesland.tw.tw5.server.common.change.repo;

import com.elitesland.tw.tw5.server.common.change.entity.PrdSystemBusinessChangeDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author liwenpeng
 * @date 2021/9/26 14:43
 */
@Repository
public interface PrdSystemBusinessChangeRepo extends JpaRepository<PrdSystemBusinessChangeDO, Long>, QuerydslPredicateExecutor<PrdSystemBusinessChangeDO> {
    /**
     * 查询变更记录
     * @return list 实体
     */
    List<PrdSystemBusinessChangeDO> findByDeleteFlagAndChangeTypeAndAndChangeDocId(Integer deleteFlag, String changeType, String changeDocId);

    PrdSystemBusinessChangeDO findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(Integer deleteFlag, String changeType, String changeDocId, String versionNo);

    Long countByDeleteFlagAndChangeTypeAndChangeDocId(Integer deleteFlag,String changeType,String changeDocId);


    @Query(value = "SELECT max(c.versionNo) FROM PrdSystemBusinessChangeDO c  where c.changeType=?1 and c.changeDocId=?2 and c.deleteFlag=0 and c.versionStatus=1")
    Integer findCurrentActiveVersion(String changeType, String docId);

    @Query(value = "SELECT max(c.versionNo) FROM PrdSystemBusinessChangeDO c  where c.changeType=?1 and c.changeDocId=?2 and c.deleteFlag=0")
    Integer findCurrentVersion(String changeType, String docId);

    @Query(value = "SELECT min(c.versionNo) FROM PrdSystemBusinessChangeDO c  where c.changeType=?1 and c.changeDocId=?2 and c.deleteFlag=0")
    Integer findInitVersion(String changeType, String docId);

    @Query(value = "SELECT max(c.id) FROM PrdSystemBusinessChangeDO c  where c.changeType=?1 and c.changeDocId=?2 and c.deleteFlag=0")
    Long findCurrentVersionId(String changeType, String docId);



}
