package com.elitesland.tw.tw5.server.common.constants;

import lombok.Getter;

/**
 * 页面配置化 组件类型
 */
public enum BusinessPageComponentTypeEnum {


    ConfigPage("ConfigPage", "标准页面"),
    ConfigVirtualPage("ConfigVirtualPage", "虚拟页面"),
    ConfigCard("ConfigCard", "容器Card"),

    ConfigInputText("ConfigInputText", "单行文本框"),
    ConfigTextArea("ConfigTextArea", "多行文本框"),
    ConfigInputNumber("ConfigInputNumber", "数值输入框"),
    ConfigInputAmt("ConfigInputAmt", "金额输入框"),
    ConfigDatePicker("ConfigDatePicker", "日期选择器"),
    ConfigDateRangePicker("ConfigDateRangePicker", "日期区间选择器"),
    ConfigDateTimePicker("ConfigDateTimePicker", "日期时间选择器"),
    ConfigDateTimeRangePicker("ConfigDateTimeRangePicker", "日期时间区间选择器"),
    ConfigSystemSelect("ConfigSystemSelect", "系统选择项"),
    ConfigBaseSelect("ConfigBaseSelect", "普通选择项"),
    ConfigAssociation("ConfigAssociation", "关联对象"),
    ConfigAttachment("ConfigAttachment", "附件"),
    ConfigImage("ConfigImage", "图片"),
    ConfigRichText("ConfigRichText", "富文本"),
    ConfigPhotograph("ConfigPhotograph", "拍照（移动端）"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    BusinessPageComponentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
