package com.elitesland.tw.tw5.server.common.crontask;


import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 定时任务
 */
@Data
public class XxlJobInfo {
    @ApiModelProperty("执行器主键")
    private int jobGroup;

    @ApiModelProperty("任务执行CRON表达式")
    private String jobCron;

    @ApiModelProperty("任务描述")
    private String jobDesc;

    private LocalDateTime addTime=LocalDateTime.now();
    private LocalDateTime updateTime=LocalDateTime.now();

    @ApiModelProperty("负责人")
    private String author;

    @ApiModelProperty("报警邮件")
    private String alarmEmail="";

    @ApiModelProperty("执行器路由策略")
    private String executorRouteStrategy="FIRST";

    @ApiModelProperty("执行器，任务Handler名称")
    private String executorHandler;

    @ApiModelProperty("任务参数")
    private String executorParam="";

    @ApiModelProperty("阻塞处理策略")
    private String executorBlockStrategy="SERIAL_EXECUTION";

    @ApiModelProperty("任务执行超时时间，单位秒  空默认")
    private int executorTimeout=0;

    @ApiModelProperty("失败重试次数  空默认")
    private int executorFailRetryCount=0;

    @ApiModelProperty("GLUE类型")
    private String glueType="BEAN";

    @ApiModelProperty("GLUE源代码")
    private String glueSource="";

    @ApiModelProperty("GLUE备注")
    private String glueRemark="程序内部创建";

    @ApiModelProperty("GLUE更新时间")
    private LocalDateTime glueUpdatetime=LocalDateTime.now();

    @ApiModelProperty("子任务ID，多个逗号分隔")
    private String childJobid="";

    @ApiModelProperty("调度状态：0-停止，1-运行")
    private int triggerStatus;
    private long triggerLastTime=0;
    private long triggerNextTime=0;
}
