package com.elitesland.tw.tw5.server.common.excel;

import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
@Builder
public class HeadVO implements Comparable<HeadVO> {
    /**
     * 列头名
     */
    private List<String> headTitle;
    /**
     * 字段名
     */
    private String key;
    /**
     * 主排序
     */
    private int index;
    /**
     * 次排序
     */
    private int order;

    @Override
    public int compareTo(HeadVO o) {
        if (this.index == o.getIndex()) {
            return this.order - o.getOrder();
        }
        return this.index - o.getIndex();
    }
}
