package com.elitesland.tw.tw5.server.common.funConfig.util;

import cn.hutool.core.util.ReUtil;
import cn.hutool.extra.expression.ExpressionUtil;
import com.elitesland.tw.tw5.api.common.funConfig.dto.BusinessPageJsonDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 业务配置JSON转换
 *
 * @author duwh
 * @date 2023/06/28
 */
@Slf4j
public class BusinessPageJsonUtil {

    public final static String REGULAR = "\\$\\{([^\\}]+)\\}";

    /**
     * 对象级联格式 扁平化处理
     *
     * @param pageJsonDTO 页面json dto
     * @return {@link List}<{@link BusinessPageJsonDTO}>
     */
    public static List<BusinessPageJsonDTO> jsonToList(BusinessPageJsonDTO pageJsonDTO) {
        List<BusinessPageJsonDTO> resultList = new ArrayList<>();
        if (null != pageJsonDTO) {
            resultList.add(pageJsonDTO);
            List<BusinessPageJsonDTO> body = pageJsonDTO.getBody();
            if (!CollectionUtils.isEmpty(body)) {
                for (BusinessPageJsonDTO child : body) {
                    resultList.addAll(jsonToList(child));
                }
            }
        }
        return resultList;
    }

    /**
     * 解析表达式
     *
     * @param content    内容
     * @param contextMap 背景图
     * @return {@link String}
     */
    public static String parseExpression(String content, Map contextMap) {
        if (StringUtils.hasText(content)) {
            // 找到表达式
            List<String> resultFindAll = ReUtil.findAll(REGULAR, content, 0, new ArrayList<>());
            for (String result : resultFindAll) {
                log.info("页面配置解析=== result");
                log.info("页面配置解析===" + result);

                // 替换 ${}
                String resultPro = result.replaceAll(REGULAR, "$1");
                // !!重要 解析表达式
                Object eval = null;
                try {
                    eval = ExpressionUtil.eval(resultPro, contextMap);
                } catch (Exception e) {
                    log.error("页面配置解析表达式失败: 表达式：{}  上下文：{}", resultPro, contextMap, e);
                }
                if (null != eval) {
                    content = content.replace(result, String.valueOf(eval));
                } else {
                    content = content.replace(result, "");
                }
            }
        }
        return content;
    }

    /**
     * 解析表达式
     *
     * @param jsonDTOList json dtolist
     * @param contextMap  背景图
     */
    public static void parseExpression(List<BusinessPageJsonDTO> jsonDTOList, Map<String, Object> contextMap) {
        if (!CollectionUtils.isEmpty(jsonDTOList)) {
            jsonDTOList.forEach(businessPageJsonDTO -> {
                // show字段解析
                parseShow(contextMap, businessPageJsonDTO);
                // 其他字段解析
            });
        }
    }

    /**
     * 分析显示
     *
     * @param contextMap          背景图
     * @param businessPageJsonDTO 业务页面json dto
     */
    private static void parseShow(Map<String, Object> contextMap, BusinessPageJsonDTO businessPageJsonDTO) {
        Object show = businessPageJsonDTO.getShow();
        if (!ObjectUtils.isEmpty(show)) {
            if (show instanceof Boolean) {

            } else if (show instanceof String) {
                String showStr = show.toString();

                // 找到表达式
                List<String> resultFindAll = ReUtil.findAll(REGULAR, show.toString(), 0, new ArrayList<>());
                for (String result : resultFindAll) {
                    log.info("页面配置解析=== result");
                    log.info("页面配置解析===" + result);

                    // 替换 ${}
                    String resultPro = result.replaceAll(REGULAR, "$1");
                    // !!重要 解析表达式
                    Object eval = null;
                    try {
                        eval = ExpressionUtil.eval(resultPro, contextMap);
                    } catch (Exception e) {
                        log.error("页面配置解析表达式失败: 表达式：{}  上下文：{}", resultPro, contextMap, e);
                    }
                    if (null != eval) {
                        showStr = showStr.replace(result, String.valueOf(eval));

                    } else {
                        showStr = showStr.replace(result, "");
                    }
                }
                show = showStr;
            } else {
                show = false;
            }
            businessPageJsonDTO.setShow(show);
        }
    }


}
