package com.elitesland.tw.tw5.server.common.log.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.log.convert.ComLogConvert;
import com.elitesland.tw.tw5.server.common.log.dao.ComLogDAO;
import com.elitesland.tw.tw5.server.common.log.entity.ComLogDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * 通用日志信息
 *
 * @author carl
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ComLogServiceImpl implements ComLogService {

    private final ComLogDAO dao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ComLogVO insert(ComLogPayload payload) {
        ComLogDO comLogDO = ComLogConvert.INSTANCE.toDo(payload);
        return ComLogConvert.INSTANCE.toVo(dao.save(comLogDO));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<ComLogVO> insertBacth(List<ComLogPayload> payloads) {
        List<ComLogDO> dos = new ArrayList<>();
        payloads.forEach(payload -> {
            dos.add(ComLogConvert.INSTANCE.toDo(payload));
        });
        dao.saveAll(dos);
        return null;
    }

    @Override
    public ComLogVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public List<ComLogVO> queryList(ComLogQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public PagingVO<ComLogVO> paging(ComLogQuery query) {
        return dao.queryPaging(query);
    }
}
