package com.elitesland.tw.tw5.server.common.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * 日期工具类
 *
 * @author duwh
 * @date 2022/12/14
 */
public class DateUtil extends cn.hutool.core.date.DateUtil {

    /**
     * 获取周数
     *
     * @param localDate 当地日期
     * @return {@link String}
     */
    public static String getYearWeek(LocalDate localDate) {
        int week = localDate.get(WeekFields.ISO.weekOfWeekBasedYear());
        String pad = week < 10 ? "0" : "";
        return localDate.get(WeekFields.ISO.weekBasedYear()) + pad + week;
    }


    /**
     * 获取周数
     *
     * @param date 日期
     * @return {@link String}
     */
    public static String getYearWeek(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int week = localDate.get(WeekFields.ISO.weekOfWeekBasedYear());
        String pad = week < 10 ? "0" : "";
        return localDate.get(WeekFields.ISO.weekBasedYear()) + pad + week;
    }

    /**
     * 获取周开始日期
     *
     * @param localDate 当地日期
     * @return {@link LocalDate}
     */
    public static LocalDate getStartWeekDay(LocalDate localDate) {
        if(null == localDate){
            return null;
        }
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return localDate.with(fieldISO, 1);
    }

    /**
     * 获取本周开始日期
     *
     * @return
     */
    public static LocalDate getStartWeekDay() {
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return now.with(fieldISO, 1);
    }

    /**
     * 获取本周结束日期 周五
     *
     * @return {@link LocalDate}
     */
    public static LocalDate getEndWeekDay(LocalDate date) {
        if(null == date){
            date = LocalDate.now();
        }
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        return date.with(fieldISO, 5);
    }

    /**
     * 获取本周七天日期
     *
     * @return
     */
    public static List<LocalDate> getNowWeekDays() {
        List<LocalDate> localDates = new ArrayList<>();
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();

        for (int i = 1; i <= 7; i++) {
            LocalDate date = now.with(fieldISO, i);
            localDates.add(date);
        }
        return localDates;
    }

    /**
     * 获取下周七天日期
     *
     * @return
     */
    public static List<LocalDate> getNextWeekDays() {
        List<LocalDate> localDates = new ArrayList<>();
        LocalDate now = LocalDate.now();
        TemporalField fieldISO = WeekFields.of(Locale.FRANCE).dayOfWeek();
        LocalDate localDate = now.with(fieldISO, 7);
        LocalDate nextDate = localDate.plusDays(1);
        for (int i = 1; i <= 7; i++) {
            LocalDate date = nextDate.with(fieldISO, i);
            localDates.add(date);
        }
        return localDates;
    }
}
