package com.elitesland.tw.tw5.server.log.aspect;

import com.el.coordinator.core.common.exception.ThrowableUtil;
import com.elitesland.tw.tw5.server.common.NotOnlineException;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RequestHolder;
import com.elitesland.tw.tw5.server.log.entity.LogDO;
import com.elitesland.tw.tw5.server.log.service.LogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

/**
 * 日志记录切面
 *
 * @author duwh
 * @date 2023/02/03
 */
@Component
@Aspect
@Slf4j
public class LogAspect {

    private final LogService logService;

    //  ThreadLocal<Long> currentTime = new ThreadLocal<>();

    public LogAspect(LogService logService) {
        this.logService = logService;
    }

    /**
     * 配置切入点 package com.elitesland.tw.tw5crm.server.prd.my.controller;
     */
    @Pointcut(value = "execution(public * com.elitesland.tw.*.server..*.*Controller.*(..))")
    public void logPointcut() {
        // 该方法无方法体,主要为了让同类中其他方法使用此切入点
    }

    /**
     * 配置环绕通知,使用在方法logPointcut()上注册的切入点
     *
     * @param joinPoint join point for advice
     */
    @Around("logPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        //  currentTime.set(System.currentTimeMillis());
        result = joinPoint.proceed();
        //LogDO log = new LogDO("INFO",System.currentTimeMillis() - currentTime.get());
        // currentTime.remove();
        //HttpServletRequest request = RequestHolder.getHttpServletRequest();
        //log.setCreator(getLoginUserName());
        //log.setCreateUserId(getLoginUserId());
        //log.setCreateTime(LocalDateTime.now());
        //log.setBrowser(StringUtil.getBrowser(request));
        //log.setRequestIp(StringUtil.getIp(request));
        //logService.save(joinPoint, log);
        return result;
    }


    /**
     * 配置异常通知
     *
     * @param joinPoint join point for advice
     * @param e         exception
     */
    @AfterThrowing(pointcut = "logPointcut()", throwing = "e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        //   currentTime.remove();
        try {
            LogDO log = new LogDO("ERROR", 0L);
            String stackTrace;
            if (e instanceof TwException || e instanceof NotOnlineException) {
                //stackTrace = "未登录或登录过期";
                return;
            } else {
                stackTrace = ThrowableUtil.getStackTrace(e);
            }
            log.setExceptionDetail(stackTrace.getBytes());
            HttpServletRequest request = RequestHolder.getHttpServletRequest();
            log.setCreator(getLoginUserName());
            log.setCreateUserId(getLoginUserId());
            log.setCreateTime(LocalDateTime.now());
            log.setBrowser(StringUtil.getBrowser(request));
            log.setRequestIp(StringUtil.getIp(request));
            logService.save((ProceedingJoinPoint) joinPoint, log);
        } catch (Exception ex) {
            log.error("错误日志记录异常", ex);
        }
    }

    public String getLoginUserName() {
        try {
            return GlobalUtil.getLoginUserName();
        } catch (Exception e) {
            return "";
        }
    }

    public Long getLoginUserId() {
        try {
            return GlobalUtil.getLoginUserId();
        } catch (Exception e) {
            return 0L;
        }
    }
}
