package com.elitesland.tw.tw5.server.log.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 日志记录
 *
 * @author duwh
 * @date 2023-02-03
 */
@Entity
@Table(name = "prd_log", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_log", comment = "日志记录")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class LogDO extends BaseModel {
    /**
     * 描述
     */
    @Comment("描述")
    @Column()
    private String description;
    /**
     * 日志类型 ERROR INFO
     */
    @Comment("日志类型 ERROR INFO")
    @Column()
    private String logType;
    /**
     * 方法路径
     */
    @Comment("方法路径")
    @Column()
    private String method;
    /**
     * 参数
     */
    @Comment("参数")
    @Column(
            name = "params",
            columnDefinition = "TEXT comment '参数' "
    )
    private String params;
    /**
     * ip来源
     */
    @Comment("ip来源")
    @Column()
    private String requestIp;
    /**
     * 耗时
     */
    @Comment("耗时")
    @Column()
    private Long time;
    /**
     * 请求所属地址
     */
    @Comment("请求所属地址")
    @Column()
    private String address;
    /**
     * 浏览器
     */
    @Comment("浏览器")
    @Column()
    private String browser;
    /**
     * 异常详情
     */
    @Comment("异常详情")
    @Column(
            name = "exception_detail",
            columnDefinition = "TEXT comment '异常详情' "
    )
    private byte[] exceptionDetail;

    public void copy(LogDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

    public LogDO() {
    }

    public LogDO(String logType, Long time) {
        this.logType = logType;
        this.time = time;
    }
}
