package com.elitesland.tw.tw5.server.prd.common;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

/**
 * <p>创建时间: 2020/2/24 17:52</p>
 *
 * @author <a href="mailto:yongqiang.zhang@elitesland.com?subject=简述你的问题&cc=&body=请描述你的问题">yongqiang.zhang</a>
 * @version 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class TwDataPresentSync implements ApplicationRunner {

    private final CacheUtil cacheUtil;
    private final TaskExecutor taskExecutor;

    @Override
    public void run(ApplicationArguments args) {
        taskExecutor.execute(() -> {
            log.info("CacheUtil init1111111111111111111111111111111111111111...");
            cacheUtil.loadRemindCache();//
            cacheUtil.loadSystemTagCache();//系统标签
            cacheUtil.loadSystemSelectionCache();//初始化系统选择项
            cacheUtil.loadSystemFunctionCache();//初始系统功能
            cacheUtil.loadSystemFunctionDataCache();//初始系统功能
            cacheUtil.loadSystemSettingCache();//初始系统设置项
            cacheUtil.loadSystemFunctionSpecialCache();//初始系统关键行为
            cacheUtil.loadSystemConfigCache();
        });
    }
}
