package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 系统选择项翻译
 *
 * @author
 * @date 2022/11/16
 */
public enum FunctionSelectionEnum {
    SystemCurrCode("SYSTEM_BASIC:CURRENCY", " 币种"),
    SystemLANGUAGE("SYSTEM_BASIC:LANGUAGE", " 语言"),
    SystemCountry("SYSTEM_BASIC:COUNTRY", " 国家"),
    PCD("SYSTEM_BASIC:PCD", "省市区"),
    SystemStatus("SYSTEM_BASIC:STATUS", "系统基础状态"),
    FlowStatus("flow_status", "流程结果状态"),

    ContentType("sys:message_notice:type", "消息类别"),
    ContentBigType("sys:message_notice:big_type", "消息大类"),
    ReleaseSource("sys:message_notice:source", "发布来源"),
    NoticeWay("sys:message_notice:notice_way", "通知方式"),
    TriggerWay("sys:message_notice:trigger_way", "触发方式"),
    MessageTag("sys:message_notice:tags", "消息标签"),
    NoticeScope("sys:message_notice:range", "通知范围"),


    EmployeeResource("org:employee:resource", "资源状态"),
    EmployeeHr("org:employee:personnel", "人事状态"),
    EmployeeCompany("org:manage:company", "公司"),
    EmployeeSex("org:employee:sex", "性别"),
    EmployeeIdType("org:employee:credentials", "证件类型"),
    EmployeeJobs("org:employee:job", "岗位"),

    CrmLeadsStatus("crm:leads_status", "线索状态"),
    CrmLeadsStage("crm:leads_stage", "线索阶段"),
    CrmLeadsSourceType("crm:leads_source_type", "线索来源类型"),
    CrmLeadsCloseReason("crm:leads_close_reason", "线索关闭原因"),
    CrmLeadsDemandProduct("crm:leads_demand_product", "线索需求产品"),
    CrmLeadsBonusDistributeType("crm:leads_bonus_distribute_type", "线索奖金分配类型"),
    CrmLeadsAnnualTurnover("crm:leads_annual_turnover", "线索企业年营业额"),
    CrmLeadsChannel("crm:leads_channel", "线索渠道"),
    CrmLeadsChannelBaidu("crm:leads_channel:baidu", "线索渠道_SEM百度"),
    CrmLeadsChannel360("crm:leads_channel:SEM_360", "线索渠道_SEM360"),
    CrmLeadsChannelOfflineActivity("crm:leads_channel:offline_activity", "线索渠道_线下活动"),
    CrmLeadsChannelThirdPartyData("crm:leads_channel:thrid_party_data", "线索渠道_三方数据"),


    CrmFollow("crm:follow", "跟进类型"),
    CrmFollowMethod("crm:follow_method", "线索跟进类型"),


    CrmCustomerIndustry("crm:leads_customer_industry", "客户行业"),
    CrmCustomerGrade("crm:customer_grade", "客户级别"),
    CrmCustomerSource("crm:customer_source", "客户来源"),
    CrmCustomerScale("crm:customer_scale", "客户公司规模"),
    CrmCustomerRegion("crm:customer_region", "客户区域"),

    // 客户经营
    CRM_CUST_OPER_TYPE("crm:cust_oper:type", "类型"),


    CrmDistributeReceiveRule("crm:offshoer_distribute_receive_rule", "近海分配领取规则"),
    CrmOffshoreRuleRegain("crm:offshore_rule_regain", "线索收回触发方式"),
    CrmPotentialCustomerStatus("crm:potential_customer_status", "潜在客户状态"),

    CrmPlanDetailType("crm:market_plan:detail_type", "市场计划明细类型"),
    CrmActDynamicType("crm:follow:activity", "市场活动跟进类型"),
    CrmCustRegion("crm:customer_region", " 客户区域"),
    CrmCustProp("crm:company_nature", " 客户性质"),
    CrmProbability("crm:oppo:trans_proba", " 成单概率"),
    CrmSalePhase("crm:oppo:sale_stage", " 销售阶段"),
    CrmOppoLevel("crm:oppo:level", " 商机级别"),
    CrmOppoDifficult("crm:oppo:difficulty_level", " 难度级别"),
    CrmOppoImportance("crm:oppo:Importance", " 重要度级别"),
    CrmOppoCloseReson("crm:closereason:oppo", "商机关闭原因"),
    CrmOppoLoseReson("crm:oppo:lose_reason", "商机丢失原因"),
    CrmOppoRoleType("crm:oppo:role_type", "商机角色类型"),
    CrmOppoStandpoint("crm:oppo:stakeholder", "商机干系人立场"),
    AbAddressType("prd:ab:addr_type", "地址类型表"),
    AbTAX_RATE("TAX_RATE", "税率"),
    AbINV_TYPE("COM:INV_TYPE", "发票类型"),
    AbTYPE("prd:ab:type", "地址簿类型"),
    AbRelate("prd:ab:relate", "相关主档"),
    AbAccount_type("prd:ab:account_type", "账户类型"),
    AbContacts_type("prd:ab:contacts_type", "联系人类型"),

    OrgEmployeeSpecialtyLevel("org:employee:specialtylevel", "专业级别"),
    OrgEmployeeWorkLevel("org:employee:worklevel","级别"),
    OrgEmployeeSequence("org:employee:workgenre", "类别"),
    OrgEmployeeType("org:employee:worktype", "工种"),
    CrmPeople("crm:people", "人脉"),
    CrmPeopleEducate("crm:people:educate", "学历"),
    ;


    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    FunctionSelectionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
