package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 工作流程状态枚举
 *
 * @author duwh
 * @date 2023/03/23
 */
public enum WorkFlowStatusEnum {

    CREATE_WORK("CREATE", "新建"),
    APPROVING_WORK("APPROVING", "审批中"),
    CHANGING_WORK("CHANGING", "变更中"),
    APPROVED_WORK("ACTIVE", "激活"),
    PENDING_WORK("PENDING", "暂挂"),
    CLOSED_WORK("CLOSED", "关闭"),
    REJECTED_WORK("REJECTED", "驳回"),
    INVALID("INVALID", "作废"),
    INTERRUPT("INTERRUPT", "中断"),
    DELETE("DELETE", "删除"),


    NOTSUBMIT("NOTSUBMIT", "未提交"),
    APPROVED("APPROVED", "审批通过"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    WorkFlowStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WorkFlowStatusEnum getByCode(String code) {
        for (WorkFlowStatusEnum value : WorkFlowStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
