package com.elitesland.tw.tw5.server.prd.file.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * 附件 文件历史版本
 *
 * @author duwh
 * @date 2022/09/20
 */
@Entity(name = "prd_file_version")
@Table(name = "prd_file_version")
@org.hibernate.annotations.Table(appliesTo = "prd_file_version", comment = "附件-历史版本")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class PrdFileVersionDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = 7160330329461873919L;

    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private String versionNo;

    @Comment("附件主键")
    @Column()
    private Long fileId;

    @Comment("变更之前附件主键")
    @Column()
    private Long oldFileId;

    @Comment("变更之后附件主键")
    @Column()
    private Long newFileId;

    public void copy(PrdFileVersionDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
