package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgDimensionService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 维度管理
 *
 * @author wangding
 */
@Api("维度管理")
@RestController
@RequiredArgsConstructor
//RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgDimensionController {

    private final PrdOrgDimensionService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/dimension/insert")
    public TwOutputUtil insert(PrdOrgDimensionPayload entity) {
        PrdOrgDimensionVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/dimension/update")
    public TwOutputUtil update(PrdOrgDimensionPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 修改状态
     *
     * @param id              主键
     * @param dimensionStatus 维度状态
     * @return result
     */
    @ApiOperation("修改状态")
    @PutMapping("/dimension/updateStatus")
    public TwOutputUtil updateStatus(Long id, Integer dimensionStatus) {
        service.updateStatus(id, dimensionStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/dimension/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据版本id查询
     *
     * @param versionId 主键
     * @return result
     */
    @ApiOperation("根据版本id查询")
    @GetMapping("/dimension/queryByVersionId")
    public TwOutputUtil queryByVersionId(Long versionId) {
        PrdOrgDimensionVO vo = service.queryByVersionId(versionId);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/dimension/list")
    public TwOutputUtil queryList() {
        List<PrdOrgDimensionVO> list = service.queryList();
        return TwOutputUtil.ok(list);
    }


}
