package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgDimensionQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgDimensionRepo;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdOrgDimensionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgDimensionRepo repo;
    private final QPrdOrgDimensionDO qdo = QPrdOrgDimensionDO.prdOrgDimensionDO;
    private final QPrdOrgOrganizationRefDO qdoRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgDimensionDO save(PrdOrgDimensionDO ado) {
        return repo.save(ado);
    }

    /**
     * 根据主键查询
     *
     * @param versionId
     * @return 结果
     */
    public PrdOrgDimensionVO queryByVersionId(Long versionId) {
        JPAQuery<PrdOrgDimensionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.versionId.eq(versionId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgDimensionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgDimensionVO.class,
                qdo.id,
                qdo.dimensionName,
                qdo.dimensionCode,
                qdo.dimensionStatus,
                qdo.remark,

                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.extString10,
                qdo.defaultFlag,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo);
    }

//

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgDimensionVO> getJpaQueryWhere(PrdOrgDimensionQuery query) {
        JPAQuery<PrdOrgDimensionVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("defaultFlag"));
        orderse.add(OrderItem.desc("createTime"));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery;
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdOrgDimensionVO> queryList(PrdOrgDimensionQuery query) {
        JPAQuery<PrdOrgDimensionVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }
//

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdOrgDimensionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getDimensionName() != null) {
            update.set(qdo.dimensionName, payload.getDimensionName());
        }
        if (payload.getDimensionCode() != null) {
            update.set(qdo.dimensionCode, payload.getDimensionCode());
        }
        if (payload.getDefaultFlag() != null) {
            update.set(qdo.defaultFlag, payload.getDefaultFlag());
        }
        if (payload.getDimensionStatus() != null) {
            update.set(qdo.dimensionStatus, payload.getDimensionStatus());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 更新默认属性
     *
     * @param
     * @return 修改的行数
     */
    public long updateDefaultFlag() {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.versionId.eq(0L)).set(qdo.defaultFlag, 1);
        // 执行修改
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param
     * @return 修改的行数
     */
    public long updateStatus(Long id, Integer status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(id)).set(qdo.dimensionStatus, status);
        // 执行修改
        return update.execute();
    }
//


////

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 根据维度id查询
     *
     * @param dimensionId
     * @return 结果
     */
    public List<PrdOrgOrganizationRefDO> queryOrgList(Long dimensionId) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.dimensionId.eq(dimensionId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询维度详情
     *
     * @param key 主键
     * @return 结果
     */
    public PrdOrgDimensionDO queryByKey(Long key) {
        JPAQuery<PrdOrgDimensionDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.id.eq(key));

        return jpaQuery.fetchFirst();
    }
}
