package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractCategoryPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractCategoryQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractCategoryService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractCategoryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合同类别控制器
 *
 * @author duwh
 * @date 2022/09/27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/sale")
@Slf4j
public class SaleContractCategoryController {

    private final SaleContractCategoryService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/contractCategory")
    public TwOutputUtil insert(SaleContractCategoryPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/contractCategory")
    public TwOutputUtil update(SaleContractCategoryPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractCategory/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractCategoryVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractCategory/paging")
    public TwOutputUtil paging(SaleContractCategoryQuery query) {
        PagingVO<SaleContractCategoryVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractCategory/list")
    public TwOutputUtil queryList(SaleContractCategoryQuery query) {
        List<SaleContractCategoryVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/contractCategory/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
