package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractTempPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractTempQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractTempService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractTempVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractTempConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractTempDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractTempRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 合同模板服务impl
 *
 * @author duwh
 * @date 2022/09/27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleContractTempServiceImpl implements SaleContractTempService {

    private final SaleContractTempRepo saleContractTempRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractTempVO insert(SaleContractTempPayload payload) {
        SaleContractTempDO entityDo = SaleContractTempConvert.INSTANCE.toDo(payload);
        saleContractTempRepo.save(entityDo);
        return SaleContractTempConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractTempVO update(SaleContractTempPayload payload) {
        SaleContractTempDO entity = saleContractTempRepo.findById(payload.getId()).orElseGet(SaleContractTempDO::new);
        Assert.notNull(entity.getId(), "合同模板不存在");
        SaleContractTempDO entityDo = SaleContractTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractTempConvert.INSTANCE.toVo(saleContractTempRepo.save(entity));
    }

    @Override
    public SaleContractTempVO queryByKey(Long key) {
        SaleContractTempDO entity = saleContractTempRepo.findById(key).orElseGet(SaleContractTempDO::new);
        Assert.notNull(entity.getId(), "合同模板不存在");
        return SaleContractTempConvert.INSTANCE.toVo(entity);
    }

    @Override
    public List<SaleContractTempVO> queryList(SaleContractTempQuery query) {
        return SaleContractTempConvert.INSTANCE.toVoList(saleContractTempRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<SaleContractTempVO> paging(SaleContractTempQuery query) {
        Page<SaleContractTempDO> page = saleContractTempRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractTempConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<SaleContractTempDO> optional = saleContractTempRepo.findById(id);
                if (!optional.isEmpty()) {
                    SaleContractTempDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    saleContractTempRepo.save(entity);
                }
            });
        }
    }


}
