package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 系统功能管理
 *
 * @author wangding
 */
@Api("系统功能处理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemFunctionController {

    private final PrdSystemFunctionService service;
    private final CacheUtil cacheUtil;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/function/insert")
    public TwOutputUtil insert(PrdSystemFunctionPayload entity) {
        PrdSystemFunctionVO vo = service.insert(entity);
        //TODO 创建功能的时候要默认分配数据行权限，创建人：最高权限，项目经理：。。。待确认
        return TwOutputUtil.ok(vo);
    }

    /**
     * 清空消息提醒缓存
     *
     * @return result
     */
    @ApiOperation("清空功能缓存")
    @GetMapping("/function/clearCache")
    public TwOutputUtil clearCache() {
        cacheUtil.loadSystemFunctionCache();
        return TwOutputUtil.ok();
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/function/update")
    public TwOutputUtil update(PrdSystemFunctionPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/function/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/function/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemFunctionVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/function/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemFunctionQuery query) {
        PagingVO<PrdSystemFunctionVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/function/list")
    public TwOutputUtil queryList(PrdSystemFunctionQuery query) {
        List<PrdSystemFunctionVO> paging = service.queryList(query);
        return TwOutputUtil.ok(paging);
    }
}
