package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 操作日志
 *
 * @author duwh
 * @date 2022/11/22
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemLogController {

    private final PrdSystemLogService prdSystemLogService;

    /**
     * 操作日志-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/log/paging")
    //@UdcNameClass
    public TwOutputUtil paging(PrdSystemLogQuery query) {
        if (ObjectUtils.isEmpty(query.getObjectId())) {
            return TwOutputUtil.error("", "objectIdb不能为空", null);
        }
        if (ObjectUtils.isEmpty(query.getObjectId())) {
            return TwOutputUtil.error("", "objectId不能为空", null);
        }
        PagingVO<PrdSystemLogVO> paging = prdSystemLogService.pageLog(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 操作日志-查询列表
     *
     * @param objectId  业务主键
     * @param logObject 类型
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/log/list")
    //@UdcNameClass
    public TwOutputUtil queryList(Long objectId, String logObject) {
        List<PrdSystemLogVO> vos = prdSystemLogService.queryLogList(objectId, logObject);
        return TwOutputUtil.ok(vos);
    }

}
