package com.elitesland.tw.tw5.server.prd.system.controller;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdTemporaryStorageService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdTemporaryStorageVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * @author zoey
 * @Description:
 * @date 2022/7/1 - 16:53
 */
@Api("暂存管理")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemStorageController {
    private final PrdTemporaryStorageService service;
    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增和修改")
    @PostMapping("/storage/saveOne")
    public TwOutputUtil insert(@RequestBody PrdTemporaryStoragePayload payload) {
        PrdTemporaryStorageVO vo = service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 局部字段更新
     * @param payload po类
     * @return result
     */
    @PostMapping("/storage/dynamicUpdate")
    public TwOutputUtil dynamicUpdate(@RequestBody PrdTemporaryStoragePayload payload) {
        service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }



    /**
     * 列表查询不分页(默认列表)
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/storage/list")
    public TwOutputUtil queryList(PrdTemporaryStorageQuery query) {
        List<PrdTemporaryStorageVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }


    /**
     * 分页查询
     *
     * @return result
     */
    @GetMapping("/storage/paging")
    public TwOutputUtil paging(PrdTemporaryStorageQuery query) {

        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("详情查询")
    @GetMapping("/storage/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        PrdTemporaryStorageVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 逻辑删除
     * @param storageIds 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/storage/delete")
    public TwOutputUtil delete(@RequestParam List<Long> storageIds) {
        service.deleteTemporaryStorageSoft(storageIds);
        return TwOutputUtil.ok();
    }


}
