package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFunctionRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 消息提醒dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemFunctionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFunctionRepo repo;
    private final QPrdSystemFunctionDO qdo = QPrdSystemFunctionDO.prdSystemFunctionDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemFunctionDO save(PrdSystemFunctionDO ado) {
        return repo.save(ado);
    }
//

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFunctionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemFunctionVO.class,
                qdo.id,
                qdo.parentId,
                qdo.functionCode,
                qdo.functionIndent,
                qdo.functionName,
                qdo.functionVersion,
                qdo.functionStatus,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.extString10,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemFunctionVO queryByKey(Long id) {
        JPAQuery<PrdSystemFunctionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
//

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFunctionVO> getJpaQueryWhere(PrdSystemFunctionQuery query) {
        JPAQuery<PrdSystemFunctionVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getFunctionCode())) {
            jpaQuery.where(qdo.functionCode.eq(query.getFunctionCode()));
        }
        if (!ObjectUtils.isEmpty(query.getFunctionName())) {
            jpaQuery.where(qdo.functionName.like(SqlUtil.toSqlLikeString(query.getFunctionName())));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdo.parentId.eq(query.getParentId()).or(qdo.id.eq(query.getParentId())));
        }
        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qdo.id.ne(query.getId()));
        }

        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            jpaQuery.where(qdo.extString1.eq(query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            jpaQuery.where(qdo.extString2.eq(query.getExtString2()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            jpaQuery.where(qdo.extString3.eq(query.getExtString3()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            jpaQuery.where(qdo.extString4.eq(query.getExtString4()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.eq(query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            jpaQuery.where(qdo.extString6.eq(query.getExtString6()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString7())) {
            jpaQuery.where(qdo.extString7.eq(query.getExtString7()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString8())) {
            jpaQuery.where(qdo.extString8.eq(query.getExtString8()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString9())) {
            jpaQuery.where(qdo.extString9.eq(query.getExtString9()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString10())) {
            jpaQuery.where(qdo.extString10.eq(query.getExtString10()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemFunctionVO> queryListDynamic(PrdSystemFunctionQuery query) {
        JPAQuery<PrdSystemFunctionVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }
//

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemFunctionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getFunctionCode() != null) {
            update.set(qdo.functionCode, payload.getFunctionCode());
        }
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        if (payload.getFunctionIndent() != null) {
            update.set(qdo.functionIndent, payload.getFunctionIndent());
        }
        if (payload.getFunctionName() != null) {
            update.set(qdo.functionName, payload.getFunctionName());
        }
        if (payload.getFunctionVersion() != null) {
            update.set(qdo.functionVersion, payload.getFunctionVersion());
        }
        if (payload.getFunctionStatus() != null) {
            update.set(qdo.functionStatus, payload.getFunctionStatus());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }

        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

//            if (nullFields.contains("remindContent")) {
//                update.setNull(qdo.remindContent);
//            }
//            if (nullFields.contains("remindContentLocale")) {
//                update.setNull(qdo.remindContentLocale);
//            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }
//

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {

        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }
////
//    /**
//     * 逻辑删除
//     *
//     * @param key 主键
//     * @return 删除的行数
//     */
//    public long deleteSoft(Long key) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo)
//                .set(qdo.deleteFlag, 1)
//                .where(qdo.id.eq(key));
//        return update.execute();
//    }

//

//

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemFunctionVO> queryPaging(PrdSystemFunctionQuery query) {
        JPAQuery<PrdSystemFunctionVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemFunctionVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemFunctionVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
