package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionSpecialDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFunctionSpecialDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFunctionSpecialRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 系统设置dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemFunctionSpecialDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFunctionSpecialRepo repo;
    private final QPrdSystemFunctionSpecialDO qdo = QPrdSystemFunctionSpecialDO.prdSystemFunctionSpecialDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemFunctionSpecialDO save(PrdSystemFunctionSpecialDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFunctionSpecialVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemFunctionSpecialVO.class,
                qdo.id,
                qdo.functionId,
                qdo.specialName,
                qdo.specialUrl,
                qdo.specialType,
                qdo.specialCode,
                qdo.specialRoles,
                qdo.systemLevel,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFunctionSpecialVO> getJpaQueryWhere(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            jpaQuery.where(qdo.functionId.eq(query.getFunctionId()));
        }
        if (!ObjectUtils.isEmpty(query.getSpecialName())) {
            jpaQuery.where(qdo.specialName.like(SqlUtil.toSqlLikeString(query.getSpecialName())));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getSpecialType())) {
            jpaQuery.where(qdo.specialType.eq(query.getSpecialType()));
        }
        if (!ObjectUtils.isEmpty(query.getSpecialCode())) {
            jpaQuery.where(qdo.specialCode.eq(query.getSpecialCode()));
        }
        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qdo.id.ne(query.getId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemFunctionSpecialVO> queryListDynamic(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemFunctionSpecialPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getFunctionId() != null) {
            update.set(qdo.functionId, payload.getFunctionId());
        }
        if (payload.getSpecialName() != null) {
            update.set(qdo.specialName, payload.getSpecialName());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getSpecialType() != null) {
            update.set(qdo.specialType, payload.getSpecialType());
        }
        if (payload.getSpecialUrl() != null) {
            update.set(qdo.specialUrl, payload.getSpecialUrl());
        }
        if (payload.getSpecialCode() != null) {
            update.set(qdo.specialCode, payload.getSpecialCode());
        }
        if (payload.getSpecialRoles() != null) {
            update.set(qdo.specialRoles, payload.getSpecialRoles());
        }
        if (payload.getSystemLevel() != null) {
            update.set(qdo.systemLevel, payload.getSystemLevel());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

//            if (nullFields.contains("remindContent")) {
//                update.setNull(qdo.remindContent);
//            }
//            if (nullFields.contains("remindContentLocale")) {
//                update.setNull(qdo.remindContentLocale);
//            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemFunctionSpecialVO queryByKey(Long id) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 检查 通过tenantId，settingKey查询判断唯一
     *
     * @param specialUrl 设置项key
     * @return 结果
     */
    public PrdSystemFunctionSpecialVO specialInspect(String specialUrl) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.specialUrl.eq(specialUrl));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemFunctionSpecialVO> queryPaging(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemFunctionSpecialVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemFunctionSpecialVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
