package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemLogDetailDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemLogDetailRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemLogDetailDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemLogDetailRepo repo;
//    private final QCrmLogDetailDO qdo = QCrmLogDetailDO.crmLogDetailDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemLogDetailDO save(PrdSystemLogDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemLogDetailDO> saveAll(List<PrdSystemLogDetailDO> dos) {
        return repo.saveAll(dos);
    }


}
