package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_remind")
@org.hibernate.annotations.Table(appliesTo = "prd_system_remind", comment = "消息提醒表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemRemindDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("提醒码")
    @Column()
    private String remindCode;

    @Comment("提醒内容")
    @Column()
    private String remindContent;


    @Comment("提醒内容国际化")
    @Column()
    private String remindContentLocale;


    @Comment("提醒类型")
    @Column()
    private String remindType;


    @Comment("前端标志")
    @Column()
    private Boolean portalFlag;

}
