package com.elitesland.tw.tw5.server.prd.system.repo;

import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface PrdSystemUserRoleRepo extends JpaRepository<PrdSystemUserRoleDO, Long>, QuerydslPredicateExecutor<PrdSystemUserRoleDO> {

    @Query(value = "SELECT ur.userId from PrdSystemUserRoleDO ur left join PrdSystemRoleDO r on ur.roleId = r.id where r.roleCode =?1 and ur.deleteFlag=0")
    List<Long> queryUserIdByRoleCode(String roleCode);

    @Query(value = "SELECT ur.userId from PrdSystemUserRoleDO ur left join PrdSystemRoleDO r on ur.roleId = r.id where r.roleCode in ?1 and ur.deleteFlag=0")
    List<Long> queryUserIdByRoleCodes(List<String> roleCodes);

    @Query(value = "SELECT r.roleCode from PrdSystemUserRoleDO ur left join PrdSystemRoleDO r on ur.roleId = r.id where ur.userId = ?1 and ur.deleteFlag=0 and r.deleteFlag=0")
    List<String> queryUserRoleCodes(Long userId);
}
