package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 消息提醒service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemFunctionServiceImpl implements PrdSystemFunctionService {
    private final PrdSystemFunctionDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    @Override
    public PrdSystemFunctionVO insert(PrdSystemFunctionPayload payload) {
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        query.setFunctionCode(payload.getFunctionCode());
        int count = dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        //   payload.setFunctionIndent(payload.getFunctionIndent().trim().toLowerCase());

        PrdSystemFunctionDO ado = PrdSystemFunctionConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        cacheUtil.loadSystemFunctionCache();
        return PrdSystemFunctionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdSystemFunctionPayload payload) {
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        query.setFunctionCode(payload.getFunctionCode());
        query.setId(payload.getId());
        int count = dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        dao.updateByKeyDynamic(payload);
        cacheUtil.loadSystemFunctionCache();
        return 0L;
    }

    @Override
    public PrdSystemFunctionVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public List<PrdSystemFunctionVO> queryList(PrdSystemFunctionQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public PagingVO<PrdSystemFunctionVO> paging(PrdSystemFunctionQuery query) {
        return dao.queryPaging(query);
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        cacheUtil.loadSystemFunctionCache();
        return true;
    }

    private void getFunctionDatas(PrdSystemFunctionVO fvo, List<Long> keyIds) {
        if (!keyIds.contains(fvo.getId())) {
            keyIds.add(fvo.getId());
        }
        if (fvo.getChildren() != null && fvo.getChildren().size() > 0) {
            fvo.getChildren().forEach(fvoChildren -> {
                getFunctionDatas(fvoChildren, keyIds);
            });
        }
    }
}
