package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemLogConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemLogDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemLogRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/17 - 15:09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemLogServiceImpl implements PrdSystemLogService {

    private final PrdSystemLogRepo repo;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogDAO dao;
    private final EntityManager entityManager;


    /**
     * 新建对象保存日志
     *
     * @param objectId
     * @param logObjectType
     * @param objectName
     */
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void saveNewLog(Long objectId, String logObjectType, String objectName) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        dao.save(logDO);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void saveNewLog(Long objectId, String logObjectType, String objectName,String extString1) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        logDO.setExtString1(extString1);
        dao.save(logDO);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void saveNewLog(Long objectId, String logObjectType, String objectName, Long createUserId) {
        PrdSystemLogDO logDO = new PrdSystemLogDO();
        logDO.setObjectId(objectId);
        logDO.setLogObject(logObjectType);
        logDO.setLogContent(objectName);
        if (null != createUserId) {
            logDO.setCreateUserId(createUserId);
        }
        dao.save(logDO);
    }

//    /**
//     * @param logObjectType    日志类型（线索，商机，潜在客户。。。）
//     * @param payload          当前对象
//     * @param objectId         主对象的id(关联表的数据更新都用这个id来关联)
//     * @param doClazz          当前对象对应的do类
//     * @param systemSelections 需要翻译的系统选择项
//     * @param userIds          需要翻译的用户
//     * @param joinObjects      需要翻译的关联表
//     * @param userIds          需要指定的变更动作名称
//     */
//    @Override
//    @SneakyThrows
//    public void saveLog(String logObjectType, Object payload, Long objectId, Class doClazz, Map<String, String> systemSelections, List<String> userIds, List<Object[]> joinObjects, Map<String, String> changeNames, Long... refId) {
//        PrdSystemLogDO logDO = new PrdSystemLogDO();
//        if (doClazz.isAnnotationPresent(Table.class)) {
//            Table table = (Table) doClazz.getAnnotation(Table.class);
//            String tableName = table.name();
//            Object doObject = doClazz.getDeclaredConstructor().newInstance();
//            //获取非空字段
//            String[] nullPropertyNames = BeanUtil.getNullPropertyNames(payload);
//            if (nullPropertyNames != null && nullPropertyNames.length > 0) {
//                //日志对象类型
//                logDO.setLogObject(logObjectType);
//                if (refId != null && refId.length > 0) {
//                    logDO.setObjectId(refId[0]);
//                } else {
//                    logDO.setObjectId(objectId);
//                }
//
//                logDO.setLogContent("更新字段");
//                List<PrdSystemLogDetailDO> logDetailDOS = new ArrayList<>();
//                for (String fieldName : nullPropertyNames) {
//                    if (fieldName.equals("ignoreWarning") || fieldName.equals("class") || fieldName.equals("id")) {
//                        continue;
//                    }
//                    String sqlFieldName = StrUtil.toUnderlineCase(fieldName);
//                    String columnName = "";
//                    Object oldValue = null;
//                    Object newValue = null;
//                    Field field = BeanUtil.getFieldByClasss(fieldName, doObject);
//                    if (field != null) {
//                        field.setAccessible(true);
//                        //数据库字段名称
//                        if (field.isAnnotationPresent(Column.class)) {
//                            Column column = field.getDeclaredAnnotation(Column.class);
//                            if (column.name() != null && !column.name().equals("")) {
//                                sqlFieldName = column.name();
//                            }
//                        }
//                        //字段翻译
//                        if (field.isAnnotationPresent(Comment.class)) {
//                            Comment comment = field.getDeclaredAnnotation(Comment.class);
//                            columnName = comment.value().replace("id", "");
//                        }
//                        Object id = BeanUtil.getAllFieldValueByFieldName("id", payload);
//                        //oldValue
//                        String sql = String.format("select %s from %s  where id=%d", sqlFieldName, tableName, id);
//                        oldValue = id == null ? null : entityManager.createNativeQuery(sql).getSingleResult();
////                        oldValue = objectId==null?null:repo.findByObjectId(sqlFieldName,tableName,objectId);
//                        logDO.setLogContent(logDO.getLogContent() + "," + columnName);
//                        PrdSystemLogDetailDO logDetailDO = new PrdSystemLogDetailDO();
//                        logDetailDO.setLeadsAttribute(field.getName());
//                        logDetailDO.setLeadsAttributeName(columnName);
//                        //newValue
//                        newValue = BeanUtil.getAllFieldValueByFieldName(fieldName, payload);
//                        if (oldValue != null && oldValue.toString().equals(newValue.toString())) {
//                            continue;
//                        }
//                        //0.确定更改动作
//                        if (changeNames!=null && changeNames.containsKey(fieldName)) {
//                            logDetailDO.setChangeName(changeNames.get(fieldName));
//                        } else {
//                            logDetailDO.setChangeName("变更为");
//                        }
//                        //1.判断是否是系统选择项
//                        if (systemSelections!=null && systemSelections.containsKey(fieldName)) {
//                            if (oldValue != null && oldValue.equals(newValue)) {
//                                continue;//结束本次循环
//                            }
//                            //翻译字段
//                            oldValue = oldValue == null ? null : cacheUtil.transferSystemSelection(systemSelections.get(fieldName), oldValue.toString());
//                            newValue = cacheUtil.transferSystemSelection(systemSelections.get(fieldName), newValue.toString());
//                        }
//                        //2.判断是否是待翻译用户字段
//                        if (userIds!=null && !userIds.isEmpty() && userIds.contains(fieldName)) {
//                            oldValue = oldValue == null ? null : cacheUtil.getUserName((Long) oldValue);
//                            newValue = cacheUtil.getUserName((Long) oldValue);
//                        }
//                        if(joinObjects!=null && !joinObjects.isEmpty()){
//                            //TODO:后续完善
//                            //3.判断是关联表翻译字段
//                            for (Object[] item : joinObjects) {
//                                if (item[0].equals(fieldName)) {
//                                    //翻译字段
//                                    Class aClass = (Class) item[1];
//                                    String column = (String) item[2];
//                                    Table joinTable = (Table) aClass.getAnnotation(Table.class);
//                                    String joinTableName = joinTable.name();
//                                    String sql1 = String.format("select %s from %s  where id=%d", column, joinTableName, oldValue);
//                                    String sql2 = String.format("select %s from %s  where id=%d", column, joinTableName, newValue);
//                                    oldValue = oldValue == null ? null : entityManager.createNativeQuery(sql1).getSingleResult();
//                                    newValue = newValue == null ? null : entityManager.createNativeQuery(sql2).getSingleResult();
//                                }
//                            }
//                        }
//                        logDetailDO.setOldValue(oldValue == null ? null : oldValue.toString());
//                        logDetailDO.setNewValue(newValue == null ? null : newValue.toString());
//                        logDetailDOS.add(logDetailDO);
//                    }
//                }
//                if (logDetailDOS != null && logDetailDOS.size() > 0) {
//                    logDO.setDetails(logDetailDOS);
//                    dao.save(logDO);
//                }
//
//            }
//        }
//    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long objectId, String logObjectType) {
//        PrdSystemObjectEnum objectEnum = PrdSystemObjectEnum.valueOf(logObjectType);
        List<PrdSystemLogDO> logDOS = dao.queryByObjectIdAndObjectType(objectId, logObjectType);
        List<PrdSystemLogVO> collect = logDOS.stream().map(e -> {
            PrdSystemLogVO vo = PrdSystemLogConvert.INSTANCE.toVo(e);
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }


    @Override
    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery logQuery) {
        Specification<PrdSystemLogDO> spec = dao.getSpec(logQuery);
        Page<PrdSystemLogDO> all = dao.findAll(spec, logQuery.getPageRequest());
        List<PrdSystemLogDO> content = all.getContent();
        List<PrdSystemLogVO> collect = content.stream().map(e -> {
            PrdSystemLogVO vo = PrdSystemLogConvert.INSTANCE.toVo(e);
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            return vo;
        }).collect(Collectors.toList());
//        类型转化
//        all.getTotalPages();
        PagingVO pagingVO= new PagingVO<>(all.getTotalElements(),collect);
        return pagingVO;
    }

}
