package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackProcessPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackProcessQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackProcessService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackProcessConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackProcessDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackProcessDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemProblemFeedbackProcessServiceImpl implements PrdSystemProblemFeedbackProcessService {

    private final PrdSystemProblemFeedbackProcessDAO dao;
    private final PrdSystemProblemFeedbackDAO feedbackDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleDAO roleDAO;
    private final PrdMessageConfigService messageConfigService;

    // @DubboReference(version = "${provider.service.version}")
    @Autowired
    private SysUserRpcService sysUserService;

    @Override
    public List<PrdSystemProblemFeedbackProcessVO> queryList(PrdSystemProblemFeedbackProcessQuery query) {
        List<PrdSystemProblemFeedbackProcessVO> processVOS = dao.queryListDynamic(query);
        for (PrdSystemProblemFeedbackProcessVO process : processVOS) {
            process.setProcessTypeDesc(cacheUtil.transferSystemSelection("sys:problem_feedback:process_type", process.getProcessType()));
            // 翻译创建人
            SysUserDTO createUser = sysUserService.getById(process.getCreateUserId());
            process.setCreateUserName(createUser.getFirstName());
        }
        return processVOS;
    }

    @Override
    @Transactional
    public PrdSystemProblemFeedbackProcessVO insert(PrdSystemProblemFeedbackProcessPayload payload) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        String userName = userDetails == null ? "" : userDetails.getUser().getUsername();
        List<Long> messageToUserIds = null;
        PrdSystemProblemFeedbackProcessDO ado = PrdSystemProblemFeedbackProcessConvert.INSTANCE.toDo(payload);
        // 判断处理类型、回复状态
        Long feedbackId = payload.getFeedbackId();
        PrdSystemProblemFeedbackVO feedbackVO = feedbackDAO.queryByKey(feedbackId);
        if (payload.getPageFlag() == 0) { // 用户页面
            // 处理类型为用户处理
            ado.setProcessType("1");
            // 回复状态为待运维回复
            feedbackVO.setReplyStatus("2");
            // 给管理员或者处理人员发消息通知
            if (feedbackVO.getDirectorUserId() != null) {
                messageToUserIds = Collections.singletonList(feedbackVO.getDirectorUserId());
            } else {
                //运维管理员
                messageToUserIds = roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
            }
        } else if (payload.getPageFlag() == 1) { // 运维页面
            // 处理类型为管理员处理
            ado.setProcessType("2");
            // 回复状态为待用户回复
            feedbackVO.setReplyStatus("1");
            // 给用户发消息通知
            messageToUserIds = Collections.singletonList(feedbackVO.getCreateUserId());
        }
        if (messageToUserIds != null) {
            String noticeSource = StringUtils.join(messageToUserIds, ",");
            PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001504");
            Map<String, Object> result = new HashMap<>();
            result.put("fromUser", userName);
            result.put("action", "新增了");
            result.put("url", String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s", feedbackVO.getId()));
            messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
//            messageConfigService.addJobMessage(ado.getId(),"reply",null,userName,noticeSource , "问题反馈回复通知",String.format("%s新增了一条问题反馈，请及时处理",userName),"进入处理>>>",String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s",feedbackVO.getId()));
        }

        ado = dao.save(ado);
        feedbackDAO.save(PrdSystemProblemFeedbackConvert.INSTANCE.toDo(feedbackVO));
        return PrdSystemProblemFeedbackProcessConvert.INSTANCE.toVo(ado);
    }
}
