package com.elitesland.tw.tw5.server.prd.tianyancha.service;

import cn.hutool.http.HttpUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.tianyancha.config.TianYanChaProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;

/**
 * 天眼查服务
 *
 * @author duwh
 * @date 2022/11/07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TianYanChaServiceImpl implements TianYanChaService {

    private final TianYanChaProperties tianYanChaProperties;
    private final ApiRequestLogService apiRequestLogService;


    /**
     * 调用天眼查接口
     *
     * @param path 路径
     * @return {@link String}
     */
    @Override
    public String getMessageByUrlToken(String path) {
        String result = "";
        String status = "";
        long start = System.currentTimeMillis();
        try {
            HttpGet request = new HttpGet(path);
            request.setHeader("Authorization", tianYanChaProperties.getToken());
            HttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                result = EntityUtils.toString(response.getEntity(), "utf-8");
            } else {
                log.error("调用天眼查接口异常，path:{}; result:{};", path, result);
            }
            status = response.getStatusLine().getStatusCode() + "";
        } catch (Exception e) {
            result = e.getMessage();
            log.error("调用天眼查接口异常，path:{}; ", path, e);
        }
        long time = System.currentTimeMillis() - start;
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.TYC, path, RequestMethod.GET, null, "Authorization:" + tianYanChaProperties.getToken(), result, status, time);
        return result;
    }


    /**
     * 搜索
     *
     * @param word     关键词
     * @param pageSize 页面大小
     * @param pageNum  页面num
     * @return {@link String}
     */
    @Override
    public String search(String word, Integer pageSize, Integer pageNum) {
        HashMap param = new HashMap(16);
        param.put("word", word);
        if (null != pageSize) {
            param.put("pageSize", pageSize);
        }
        if (null != pageNum) {
            param.put("pageNum", pageNum);
        }
        final String uri = HttpUtil.urlWithForm(tianYanChaProperties.getUriSearch(), param, null, true);
        return getMessageByUrlToken(uri);
    }


}
