package com.elitesland.tw.tw5.server.prd.work.service;

import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentHistoryPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentHistoryQuery;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentHistoryService;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentHistoryVO;
import com.elitesland.tw.tw5.server.prd.work.convert.PrdWorkAssignmentHistoryConvert;
import com.elitesland.tw.tw5.server.prd.work.dao.PrdWorkAssignmentHistoryDAO;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentHistoryDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class PrdWorkAssignmentHistoryServiceImpl implements PrdWorkAssignmentHistoryService {
    private final PrdWorkAssignmentHistoryDAO dao;
    @Override
    public PrdWorkAssignmentHistoryVO insert(PrdWorkAssignmentHistoryPayload payload) {
        PrdWorkAssignmentHistoryDO ado = PrdWorkAssignmentHistoryConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        return PrdWorkAssignmentHistoryConvert.INSTANCE.toVo(ado);
    }

    @Override
    public List<PrdWorkAssignmentHistoryVO> insertAll(Collection<PrdWorkAssignmentHistoryPayload> payloadList) {
        List<PrdWorkAssignmentHistoryDO> historyDOS = payloadList.stream().map(e -> PrdWorkAssignmentHistoryConvert.INSTANCE.toDo(e)).collect(Collectors.toList());
        List<PrdWorkAssignmentHistoryDO> saveHistoryDOS = dao.saveAll(historyDOS);
        return saveHistoryDOS.stream().map(e -> PrdWorkAssignmentHistoryConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
    }

    @Override
    public List<PrdWorkAssignmentHistoryVO> queryList(PrdWorkAssignmentHistoryQuery query) {
        List<PrdWorkAssignmentHistoryVO> processVOS = dao.queryListDynamic(query);
        return processVOS;
    }

    @Override
    public PrdWorkAssignmentHistoryVO update(PrdWorkAssignmentHistoryPayload payload) {
        PrdWorkAssignmentHistoryDO ado = PrdWorkAssignmentHistoryConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        return PrdWorkAssignmentHistoryConvert.INSTANCE.toVo(ado);
    }
}
