package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.yeedoc.service.YeedocWorkflowService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 易稻壳工作流交互
 *
 * @author carl
 * @date 2023-07-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class YeedocWorkflowServiceImpl extends BaseServiceImpl implements YeedocWorkflowService {
    private final WorkflowUtil workflowUtil;
    private final HttpUtil httpUtil;

    @Value("${yeedoc.queryGroupTypeUrl:testUrl}")
    private String queryGroupTypeUrl;
    @Value("${yeedoc.queryGroupDataUrl:testUrl}")
    private String queryGroupDataUrl;


    @Override
    public ProcessInfo submitProcess(StartProcessPayload payload) {
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(payload);
        return processInfo;
    }

    @Override
    public Object queryGroupType() {
        Map<String,Object> map= new HashMap<>();
        map.put("Source",1);
        String result = httpUtil.sendGet(queryGroupTypeUrl, map);
        Object yeedocResultData = httpUtil.getYeedocResultData(result);

        return yeedocResultData;
    }

    @Override
    public Object queryGroupData(String key) {
        Map<String,Object> map= new HashMap<>();
        map.put("key",key);
        map.put("Source",1);
        String result = httpUtil.sendGet(queryGroupDataUrl,map);
        Object yeedocResultData = httpUtil.getYeedocResultData(result);
        return yeedocResultData;
    }
}
