package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 员工管理
 *
 * @author wangding
 */
@Api("员工管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgEmployeeController {

    private final PrdOrgEmployeeService service;


    /**
     * 易稻壳批量新增
     *
     * @param entitys po类
     * @return result
     */
    @ApiOperation("易稻壳批量新增")
    @PostMapping("/employee/yeedocBatchInsert")
    ////@GlobalTransactional
    public TwOutputUtil yeedocBatchInsert(@RequestBody List<PrdOrgEmployeePayload> entitys) {
        return TwOutputUtil.ok(service.yeedocBatchInsert(entitys));

    }

    /**
     * 易稻壳新增
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("易稻壳新增")
    @PostMapping("/employee/yeedocInsert")
    ////@GlobalTransactional
    public TwOutputUtil yeedocInsert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(service.yeedocInsert(entity));

    }

    /**
     * 通过租户新增
     *
     * @param entity po类
     * @return result
     */
    @PostMapping("/employee/saveTenantUser")
    public TwOutputUtil saveTenantUser(PrdOrgTenantEmployeePayload entity) {
        return TwOutputUtil.ok(service.saveTenantUser(entity));

    }

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/employee/insert")
    ////@GlobalTransactional
    public TwOutputUtil insert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(service.insert(entity));

    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/employee/update")
    ////@GlobalTransactional
    public TwOutputUtil update(@RequestBody PrdOrgEmployeePayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 修改员工组织关系
     *
     * @param payloadStrs po类
     * @return result
     */
    @ApiOperation("修改员工组织关系")
    @PutMapping("/employee/updateEmployeeRef")
    public TwOutputUtil updateEmployeeRef(String payloadStrs) {
        service.updateEmployeeRef(JSONObject.parseArray(payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();

    }

    /**
     * 人员选择器
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("人员选择器")
    @GetMapping("/employee/list")
    public TwOutputUtil queryList(PrdOrgEmployeeQuery query) {
        List<PrdOrgEmployeeVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * 分页条件查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/employee/pading")
    public TwOutputUtil queryPading(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/employee/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdOrgEmployeeVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 根据主键查询所有上级id
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("根据主键查询所有上级id")
    @GetMapping("/employee/queryParentIds/{key}")
    public TwOutputUtil queryParentIds(@PathVariable Long key) {
        return TwOutputUtil.ok(service.queryParentIdsByUserId(key));
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/employee/delete")
    //@GlobalTransactional
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 移除员工组织
     *
     * @param userId 员工id
     * @param orgIds 组织ids
     * @return result
     */
    @ApiOperation("移除员工组织")
    @PutMapping("/employee/deleteOrg")
    public TwOutputUtil deleteOrg(Long userId, Long[] orgIds) {
        service.deleteOrgRefSoft(userId, Arrays.asList(orgIds));
        return TwOutputUtil.ok();
    }


    /**
     * 重置密码
     *
     * @param userId 被操作员工主键
     * @return result
     */
    @ApiOperation("重置密码")
    @GetMapping("/employee/resetEmployeePawword/{userId}")
    public TwOutputUtil resetEmployeePawword(@PathVariable Long userId) {
        service.resetEmployeePawword(userId);
        return TwOutputUtil.ok();
    }

    /**
     * 更新企业微信id
     *
     * @param userId
     * @return result
     */
    @GetMapping("/employee/updateWecomId")
    public TwOutputUtil updateWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        service.updateWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    /**
     * 根据主键查询所有下级id
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("根据主键查询所有下级id")
    @GetMapping("/employee/queryLowerUserIds/{key}")
    public TwOutputUtil queryLowerUserIds(@PathVariable Long key) {
        return TwOutputUtil.ok(service.querySubordinatesIdsByUserId(key));
    }

//    /**
//     * 全局更新企业微信id
//     *
//     * @return result
//     */
//    @GetMapping("/employee/updateAllWecomId")
//    public TwOutputUtil updateAllWecomId() {
//        service.updateAllWecomId();
//        return TwOutputUtil.ok();
//    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/employee/batchExport")
    public void batchExport(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        service.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/employee/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    //@GlobalTransactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importEmployees(file);
        return TwOutputUtil.ok();
    }
//    /**
//     * 测试批量导出excel
//     *
//     * @return result
//     */
//    @ApiOperation("测试")
//    @GetMapping("/employee/batchExportTest")
//
//    public void batchExportTest(HttpServletResponse response) {
//        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
//        PagingVO<PrdOrgEmployeeVO> evo = service.paging(query);
//        List<PrdOrgEmployeeVO> list = evo.getRecords();
//        service.downloadPlus(response, list);
//    }
}
