package com.elitesland.tw.tw5.server.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRequestLogPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRequestLogQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRequestLogService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRequestLogVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.shorturl.convert.ShortUrlRequestLogConvert;
import com.elitesland.tw.tw5.server.prd.shorturl.dao.ShortUrlRequestLogDAO;
import com.elitesland.tw.tw5.server.prd.shorturl.entity.ShortUrlRequestLogDO;
import com.elitesland.tw.tw5.server.prd.shorturl.repo.ShortUrlRequestLogRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ShortUrlRequestLogServiceImpl extends BaseServiceImpl implements ShortUrlRequestLogService {

    private final ShortUrlRequestLogRepo shortUrlRequestLogRepo;
    private final ShortUrlRequestLogDAO shortUrlRequestLogDAO;

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public PagingVO<ShortUrlRequestLogVO> queryPaging(ShortUrlRequestLogQuery query){
        return shortUrlRequestLogDAO.queryPaging(query);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public List<ShortUrlRequestLogVO> queryListDynamic(ShortUrlRequestLogQuery query){
        return shortUrlRequestLogDAO.queryListDynamic(query);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO queryByKey(Long key) {
        ShortUrlRequestLogDO entity = shortUrlRequestLogRepo.findById(key).orElseGet(ShortUrlRequestLogDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ShortUrlRequestLogVO vo = ShortUrlRequestLogConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO insert(ShortUrlRequestLogPayload payload) {
        ShortUrlRequestLogDO entityDo = ShortUrlRequestLogConvert.INSTANCE.toDo(payload);
        return ShortUrlRequestLogConvert.INSTANCE.toVo(shortUrlRequestLogRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO update(ShortUrlRequestLogPayload payload) {
        ShortUrlRequestLogDO entity = shortUrlRequestLogRepo.findById(payload.getId()).orElseGet(ShortUrlRequestLogDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ShortUrlRequestLogDO entityDo = ShortUrlRequestLogConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ShortUrlRequestLogConvert.INSTANCE.toVo(shortUrlRequestLogRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ShortUrlRequestLogDO> optional = shortUrlRequestLogRepo.findById(id);
                if (!optional.isEmpty()) {
                    ShortUrlRequestLogDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    shortUrlRequestLogRepo.save(entity);
                }
             });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public void log(ShortUrlRefVO shortUrlRefVO, HttpServletRequest request) {
        ShortUrlRequestLogDO entity = new ShortUrlRequestLogDO();
        entity.setShortId(null != shortUrlRefVO ? shortUrlRefVO.getId() : null);
        entity.setShortUrl(null != shortUrlRefVO ? shortUrlRefVO.getShortUrl() : null);
        entity.setLongUrl(null != shortUrlRefVO ? shortUrlRefVO.getLongUrl() : null);

        entity.setCreator(getLoginUserName());
        entity.setCreateUserId(getLoginUserId());
        entity.setCreateTime(LocalDateTime.now());
        entity.setBrowser(StringUtil.getBrowser(request));
        String ip = StringUtil.getIp(request);
        entity.setRequestIp(ip);
        entity.setAddress(StringUtil.getCityInfo(ip));

        //TODO  记录参数
        shortUrlRequestLogRepo.save(entity);
    }

    public String getLoginUserName() {
        try {
            return GlobalUtil.getLoginUserName();
        } catch (Exception e) {
            return "";
        }
    }

    public Long getLoginUserId() {
        try {
            return GlobalUtil.getLoginUserId();
        } catch (Exception e) {
            return 0L;
        }
    }

}
