/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.checkrepeat.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.checkrepeat.payload.CheckRepeatSettingPayload;
import com.elitesland.tw.tw5.api.checkrepeat.query.CheckRepeatSettingQuery;
import com.elitesland.tw.tw5.api.checkrepeat.service.CheckRepeatSettingService;
import com.elitesland.tw.tw5.api.checkrepeat.vo.CheckRepeatSettingVO;
import com.elitesland.tw.tw5.server.checkrepeat.convert.CheckRepeatSettingConvert;
import com.elitesland.tw.tw5.server.checkrepeat.dao.CheckRepeatSettingDAO;
import com.elitesland.tw.tw5.server.checkrepeat.entity.CheckRepeatSettingDO;
import com.elitesland.tw.tw5.server.checkrepeat.repo.CheckRepeatSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CheckRepeatSettingServiceImpl
extends BaseServiceImpl
implements CheckRepeatSettingService {
    private static final Logger log = LoggerFactory.getLogger(CheckRepeatSettingServiceImpl.class);
    private final CheckRepeatSettingRepo checkRepeatSettingRepo;
    private final CheckRepeatSettingDAO checkRepeatSettingDAO;

    public PagingVO<CheckRepeatSettingVO> queryPaging(CheckRepeatSettingQuery query) {
        return this.checkRepeatSettingDAO.queryPaging(query);
    }

    public List<CheckRepeatSettingVO> queryListDynamic(CheckRepeatSettingQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return this.checkRepeatSettingDAO.queryListDynamic(query);
    }

    public CheckRepeatSettingVO queryByKey(Long key) {
        CheckRepeatSettingDO entity = this.checkRepeatSettingRepo.findById(key).orElseGet(CheckRepeatSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CheckRepeatSettingVO vo = CheckRepeatSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CheckRepeatSettingVO insert(CheckRepeatSettingPayload payload) {
        Long userId = GlobalUtil.getLoginUserId();
        this.checkRepeatSettingRepo.deleteByCreateUserIdAndType(userId, payload.getType());
        CheckRepeatSettingDO entityDo = CheckRepeatSettingConvert.INSTANCE.toDo(payload);
        return CheckRepeatSettingConvert.INSTANCE.toVo((CheckRepeatSettingDO)this.checkRepeatSettingRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public CheckRepeatSettingVO update(CheckRepeatSettingPayload payload) {
        CheckRepeatSettingDO entity = this.checkRepeatSettingRepo.findById(payload.getId()).orElseGet(CheckRepeatSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CheckRepeatSettingDO entityDo = CheckRepeatSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CheckRepeatSettingConvert.INSTANCE.toVo((CheckRepeatSettingDO)this.checkRepeatSettingRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CheckRepeatSettingPayload payload) {
        CheckRepeatSettingDO entity = this.checkRepeatSettingRepo.findById(payload.getId()).orElseGet(CheckRepeatSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.checkRepeatSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.checkRepeatSettingRepo.findById(id);
                if (!optional.isEmpty()) {
                    CheckRepeatSettingDO entity = (CheckRepeatSettingDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.checkRepeatSettingRepo.save(entity);
                }
            });
        }
    }

    public CheckRepeatSettingServiceImpl(CheckRepeatSettingRepo checkRepeatSettingRepo, CheckRepeatSettingDAO checkRepeatSettingDAO) {
        this.checkRepeatSettingRepo = checkRepeatSettingRepo;
        this.checkRepeatSettingDAO = checkRepeatSettingDAO;
    }
}

