/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.partner.common.query.AddressBookQuery;
import com.elitesland.tw.tw5.api.partner.common.service.AddressBookService;
import com.elitesland.tw.tw5.api.partner.common.vo.AddressBookVO;
import com.elitesland.tw.tw5.server.partner.common.convert.AddressBookConvert;
import com.elitesland.tw.tw5.server.partner.common.dao.AddressBookDAO;
import com.elitesland.tw.tw5.server.partner.common.entity.AddressBookDO;
import com.elitesland.tw.tw5.server.partner.common.repo.AddressBookRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AddressBookServiceImpl
extends BaseServiceImpl
implements AddressBookService {
    private static final Logger log = LoggerFactory.getLogger(AddressBookServiceImpl.class);
    private final AddressBookRepo addressBookRepo;
    private final AddressBookDAO addressBookDAO;

    public PagingVO<AddressBookVO> queryPaging(AddressBookQuery query) {
        return this.addressBookDAO.queryPaging(query);
    }

    public List<AddressBookVO> queryListDynamic(AddressBookQuery query) {
        return this.addressBookDAO.queryListDynamic(query);
    }

    public AddressBookVO queryByKey(Long key) {
        AddressBookDO entity = this.addressBookRepo.findById(key).orElseGet(AddressBookDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AddressBookVO vo = AddressBookConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AddressBookVO insert(AddressBookPayload payload) {
        AddressBookDO entityDo = AddressBookConvert.INSTANCE.toDo(payload);
        return AddressBookConvert.INSTANCE.toVo((AddressBookDO)this.addressBookRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public AddressBookVO update(AddressBookPayload payload) {
        AddressBookDO entity = this.addressBookRepo.findById(payload.getId()).orElseGet(AddressBookDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AddressBookDO entityDo = AddressBookConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AddressBookConvert.INSTANCE.toVo((AddressBookDO)this.addressBookRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.addressBookRepo.findById(id);
                if (!optional.isEmpty()) {
                    AddressBookDO entity = (AddressBookDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.addressBookRepo.save(entity);
                }
            });
        }
    }

    public AddressBookServiceImpl(AddressBookRepo addressBookRepo, AddressBookDAO addressBookDAO) {
        this.addressBookRepo = addressBookRepo;
        this.addressBookDAO = addressBookDAO;
    }
}

