/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.team.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.partner.team.convert.BusinessTeamMemberConvert;
import com.elitesland.tw.tw5.server.partner.team.dao.BusinessTeamMemberDAO;
import com.elitesland.tw.tw5.server.partner.team.entity.BusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.partner.team.repo.BusinessTeamMemberRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessSelectionEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessTeamMemberServiceImpl
extends BaseServiceImpl
implements BusinessTeamMemberService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTeamMemberServiceImpl.class);
    private final BusinessTeamMemberRepo businessTeamMemberRepo;
    private final BusinessTeamMemberDAO businessTeamMemberDAO;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    public PagingVO<BusinessTeamMemberVO> queryPaging(BusinessTeamMemberQuery query) {
        PagingVO<BusinessTeamMemberVO> businessTeamMemberVOPagingVO = this.businessTeamMemberDAO.queryPaging(query);
        businessTeamMemberVOPagingVO.stream().forEach(vo -> vo.setMemberRoleName(this.traslate(vo.getMemberRole(), vo.getType())));
        return businessTeamMemberVOPagingVO;
    }

    public List<BusinessTeamMemberVO> queryListDynamic(BusinessTeamMemberQuery query) {
        List<BusinessTeamMemberVO> businessTeamMemberVOS = this.businessTeamMemberDAO.queryListDynamic(query);
        businessTeamMemberVOS.stream().forEach(vo -> vo.setMemberRoleName(this.traslate(vo.getMemberRole(), vo.getType())));
        return businessTeamMemberVOS;
    }

    public BusinessTeamMemberVO queryByKey(Long key) {
        BusinessTeamMemberDO entity = this.businessTeamMemberRepo.findById(key).orElseGet(BusinessTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        entity.setMemberRoleName(this.traslate(entity.getMemberRole(), entity.getType()));
        BusinessTeamMemberVO vo = BusinessTeamMemberConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<BusinessTeamMemberVO> insert(List<BusinessTeamMemberPayload> payload) {
        Long objectId = null;
        if (payload != null && payload.size() > 0) {
            objectId = payload.get(0).getObjectId();
            this.businessTeamMemberRepo.deleteByObjectId(objectId);
        }
        HashSet userIdset = new HashSet();
        StringBuilder createUserId = new StringBuilder();
        payload.forEach(p -> {
            if (p.getIsCreator() != null && p.getIsCreator().booleanValue()) {
                p.setSortNo(Integer.valueOf(1));
                createUserId.append(p.getUserId().toString());
            } else {
                userIdset.add(p.getUserId());
            }
        });
        if (!StringUtils.isEmpty((CharSequence)createUserId) && userIdset.contains(Long.valueOf(createUserId.toString()))) {
            throw TwException.error((String)"", (String)"\u521b\u5efa\u4eba\u5458\u6dfb\u52a0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
        }
        List<BusinessTeamMemberDO> entityDo = BusinessTeamMemberConvert.INSTANCE.toDoList(payload);
        if (objectId != null) {
            if (BusinessTeamTypeEnum.BID.getCode().equals(payload.get(0).getType())) {
                this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BID_PROJECT.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
            }
            if (BusinessTeamTypeEnum.PARTNER.getCode().equals(payload.get(0).getType())) {
                this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
            }
        }
        return BusinessTeamMemberConvert.INSTANCE.toVoList(this.businessTeamMemberRepo.saveAll(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTeamMemberVO update(BusinessTeamMemberPayload payload) {
        BusinessTeamMemberDO entity = this.businessTeamMemberRepo.findById(payload.getId()).orElseGet(BusinessTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTeamMemberDO entityDo = BusinessTeamMemberConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTeamMemberConvert.INSTANCE.toVo((BusinessTeamMemberDO)this.businessTeamMemberRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long objectId) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessTeamMemberRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessTeamMemberDO entity = (BusinessTeamMemberDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessTeamMemberRepo.save(entity);
                }
            });
            if (objectId != null) {
                BusinessTeamMemberDO businessTeamMemberDO = this.businessTeamMemberRepo.findById(keys.get(0)).orElseGet(BusinessTeamMemberDO::new);
                if (BusinessTeamTypeEnum.BID.getCode().equals(businessTeamMemberDO.getType())) {
                    this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BID_PROJECT.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
                }
                if (BusinessTeamTypeEnum.PARTNER.getCode().equals(businessTeamMemberDO.getType())) {
                    this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
                }
            }
        }
    }

    public BusinessTeamMemberVO save(BusinessTeamMemberPayload payload) {
        BusinessTeamMemberDO entityDo = BusinessTeamMemberConvert.INSTANCE.toDo(payload);
        return BusinessTeamMemberConvert.INSTANCE.toVo((BusinessTeamMemberDO)this.businessTeamMemberRepo.save(entityDo));
    }

    public List<BusinessTeamMemberVO> queryByObjectIdAndRole(Long objectId, String role) {
        return this.businessTeamMemberDAO.queryByObjectIdAndRole(objectId, role);
    }

    public Long count(BusinessTeamMemberQuery query) {
        return this.businessTeamMemberDAO.count(query);
    }

    public void updateTeamByIdentityChange(Long objectId, String identity) {
        String selectKey = BusinessSelectionEnum.valueOf(identity).getCode();
        PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(selectKey);
        List<String> roleList = Arrays.asList(systemSelection.getExtString1().split(","));
        this.businessTeamMemberDAO.updateTeamByIdentityChange(objectId, roleList);
    }

    public String traslate(String roleCode, String type) {
        if (BusinessTeamTypeEnum.PARTNER.getCode().equals(type)) {
            return BusinessTeamRoleEnum.valueOf((String)roleCode).getDesc();
        }
        if (BusinessTeamTypeEnum.BID.getCode().equals(type)) {
            return BusinessTeamRoleEnum.valueOf((String)roleCode).getDesc();
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByObjectId(Long objectId) {
        this.businessTeamMemberRepo.deleteByObjectId(objectId);
    }

    public BusinessTeamMemberServiceImpl(BusinessTeamMemberRepo businessTeamMemberRepo, BusinessTeamMemberDAO businessTeamMemberDAO, PrdSystemLogService logService, CacheUtil cacheUtil) {
        this.businessTeamMemberRepo = businessTeamMemberRepo;
        this.businessTeamMemberDAO = businessTeamMemberDAO;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
    }
}

