/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationMemberVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmCustomerOperationMemberController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerOperationMemberController.class);
    private final CrmCustomerOperationMemberService service;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final CacheUtil cacheUtil;

    @PostMapping(value={"/customerOperationMember"})
    public TwOutputUtil insert(CrmCustomerOperationMemberPayload payload) {
        return TwOutputUtil.ok((Object)this.service.insert(payload));
    }

    @PostMapping(value={"/customerOperationMember/saveAll"})
    public TwOutputUtil saveAll(@RequestBody CrmCustomerOperationMemberListPayload payload) {
        return TwOutputUtil.ok((Object)this.service.saveAll(payload));
    }

    @PutMapping(value={"/customerOperationMember"})
    public TwOutputUtil update(CrmCustomerOperationMemberPayload payload) {
        return TwOutputUtil.ok((Object)this.service.update(payload));
    }

    @GetMapping(value={"/customerOperationMember/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmCustomerOperationMemberVO prdFileVO = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)prdFileVO);
    }

    @GetMapping(value={"/customerOperationMember/paging"})
    public TwOutputUtil paging(CrmCustomerOperationMemberQuery query) {
        if (null == query.getOperId()) {
            return TwOutputUtil.error((String)"", (String)"operId\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        query.setEndTime(LocalDateTime.now());
        query.setDisabledFlag(Integer.valueOf(0));
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/customerOperationMember/list"})
    public TwOutputUtil queryList(CrmCustomerOperationMemberQuery query) {
        Long operId = query.getOperId();
        if (null == operId) {
            return TwOutputUtil.error((String)"", (String)"operId\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        query.setEndTime(LocalDateTime.now());
        query.setDisabledFlag(Integer.valueOf(0));
        List<Object> list = new ArrayList<CrmCustomerOperationMemberVO>();
        List vos = this.service.queryList(query);
        list.addAll(vos);
        CrmCustomerOperationVO operationVO = this.crmCustomerOperationService.queryByKey(operId);
        if (null != operationVO) {
            this.addManagerUserInfo(list, operationVO.getProductUserId());
            this.addManagerUserInfo(list, operationVO.getServiceUserId());
            this.addManagerUserInfo(list, operationVO.getBusinessUserId());
            this.addManagerUserInfo(list, operationVO.getCareUserId());
            this.addManagerUserInfo(list, operationVO.getOperationUserId());
        }
        list = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CrmCustomerOperationMemberVO>(Comparator.comparing(CrmCustomerOperationMemberVO::getUserId))), ArrayList::new));
        return TwOutputUtil.ok(list);
    }

    private void addManagerUserInfo(List<CrmCustomerOperationMemberVO> list, Long userId) {
        if (null != userId) {
            list.add(new CrmCustomerOperationMemberVO(userId, this.cacheUtil.getUserName(userId)));
        }
    }

    @DeleteMapping(value={"/customerOperationMember/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmCustomerOperationMemberController(CrmCustomerOperationMemberService service, CrmCustomerOperationService crmCustomerOperationService, CacheUtil cacheUtil) {
        this.service = service;
        this.crmCustomerOperationService = crmCustomerOperationService;
        this.cacheUtil = cacheUtil;
    }
}

