/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u516c\u6d77\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOpenseaController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpenseaController.class);
    private final CrmOpenseaService service;
    private final CrmPotentialCustomerService potentialCustomerService;

    @ApiOperation(value="\u65b0\u589e\u548c\u4fee\u6539")
    @PostMapping(value={"/opensea/saveOne"})
    public TwOutputUtil insert(@RequestBody CrmOpenseaPayload payload) {
        CrmOpenseaVO vo = this.service.saveOne(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @PostMapping(value={"/opensea/dynamicUpdate"})
    public TwOutputUtil dynamicUpdate(@RequestBody CrmOpenseaPayload payload) {
        this.service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/opensea/list"})
    public TwOutputUtil queryList(CrmOpenseaQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok((Object)list);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/opensea/list/my"})
    public TwOutputUtil queryListMy() {
        List list = this.service.queryListMy();
        return TwOutputUtil.ok((Object)list);
    }

    @GetMapping(value={"/opensea/paging"})
    public TwOutputUtil paging(CrmOpenseaQuery query) {
        return TwOutputUtil.ok((Object)this.service.paging(query));
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/opensea/detail/{id}"})
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmOpenseaVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok((Object)vo);
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/opensea/delete"})
    public TwOutputUtil delete(@RequestParam Long openseaId, @RequestParam(required=false) Long newOpenseaId) {
        this.potentialCustomerService.deleteOpenseaSoft(openseaId, newOpenseaId);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/opensea/batchExport"})
    public void batchExport(HttpServletResponse response, CrmOpenseaQuery query) {
        this.service.downloadOpensea(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/opensea/batchImport"}, consumes={"multipart/form-data"})
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        this.service.importOpensea(file);
        return TwOutputUtil.ok();
    }

    public CrmOpenseaController(CrmOpenseaService service, CrmPotentialCustomerService potentialCustomerService) {
        this.service = service;
        this.potentialCustomerService = potentialCustomerService;
    }
}

