/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOperationPlanDetailController {
    private static final Logger log = LoggerFactory.getLogger(CrmOperationPlanDetailController.class);
    private final CrmOperationPlanDetailService service;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final CrmOperationPlanDetailMemberService memberService;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final PrdSystemRoleDAO systemRoleDAO;

    @PostMapping(value={"/operationPlanDetail"})
    public TwOutputUtil insert(@RequestBody CrmOperationPlanDetailPayload payload) {
        return TwOutputUtil.ok((Object)this.service.insert(payload));
    }

    @PutMapping(value={"/operationPlanDetail"})
    public TwOutputUtil update(CrmOperationPlanDetailPayload payload) {
        return TwOutputUtil.ok((Object)this.service.update(payload));
    }

    @GetMapping(value={"/operationPlanDetail/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmOperationPlanDetailVO prdFileVO = this.service.queryByKey(key);
        return TwOutputUtil.ok((Object)prdFileVO);
    }

    @GetMapping(value={"/operationPlanDetail/log/list/{key}"})
    public TwOutputUtil logList(@PathVariable Long key) {
        List prdSystemLogVOS = this.service.queryLogList(key);
        return TwOutputUtil.ok((Object)prdSystemLogVOS);
    }

    @GetMapping(value={"/operationPlanDetail/paging"})
    @UdcNameClass
    public TwOutputUtil paging(CrmOperationPlanDetailQuery query) {
        PagingVO paging;
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            query.setManagerFlag(true);
            paging = this.service.pagingDataFilter(query);
        } else {
            List userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty((Collection)userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                query.setManagerFlag(true);
                paging = this.service.pagingDataFilter(query);
            } else {
                paging = this.service.pagingDataFilter(query);
            }
        }
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            records.forEach(vo -> {
                vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.OPER_PLAN.getCode(), vo.getId())));
                vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.OPER_PLAN.getCode(), vo.getId())));
            });
        }
        return TwOutputUtil.ok((Object)paging);
    }

    @GetMapping(value={"/operationPlanDetail/list"})
    @UdcNameClass
    public TwOutputUtil queryList(CrmOperationPlanDetailQuery query) {
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok((Object)vos);
    }

    @GetMapping(value={"/operationPlanDetail/listForTimeSheet"})
    @UdcNameClass
    public TwOutputUtil listForTimeSheet() {
        List vos = this.service.listForTimeSheet();
        return TwOutputUtil.ok((Object)vos);
    }

    @DeleteMapping(value={"/operationPlanDetail/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmOperationPlanDetailController(CrmOperationPlanDetailService service, CrmCustomerOperationService crmCustomerOperationService, CrmOperationPlanDetailMemberService memberService, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService, PrdSystemRoleDAO systemRoleDAO) {
        this.service = service;
        this.crmCustomerOperationService = crmCustomerOperationService;
        this.memberService = memberService;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.systemRoleDAO = systemRoleDAO;
    }
}

